/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.resource.font;

import java.util.Arrays;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import org.jrebirth.af.api.resource.font.FontExtension;
import org.jrebirth.af.api.resource.font.FontName;
import org.jrebirth.af.core.resource.font.AbstractBaseFont;
import org.jrebirth.af.core.resource.font.CustomFontName;

public class RealFont
extends AbstractBaseFont {
    private final transient BooleanProperty skipFontsFolderProperty = new SimpleBooleanProperty();

    public RealFont(FontName name, double size, FontExtension extension, boolean skipFontsFolder) {
        super(name, size, extension);
        this.skipFontsFolderProperty.set(skipFontsFolder);
    }

    public RealFont(FontName name, double size, FontExtension extension) {
        this(name, size, extension, false);
    }

    public RealFont(FontName name, double size, boolean skipFontsFolder) {
        super(name, size);
        this.skipFontsFolderProperty.set(skipFontsFolder);
    }

    public RealFont(FontName name, double size) {
        this(name, size, false);
    }

    public boolean skipFontsFolder() {
        return this.skipFontsFolderProperty.get();
    }

    public BooleanProperty skipFontsFolderProperty() {
        return this.skipFontsFolderProperty;
    }

    @Override
    public void parse(String ... parameters) {
        if (parameters.length >= 1) {
            this.nameProperty().set((Object)new CustomFontName(parameters[0]));
        }
        if (parameters.length >= 2) {
            this.sizeProperty().set(this.readDouble(parameters[1], 1.0, 1000.0));
        }
        if (parameters.length == 3) {
            this.skipFontsFolderProperty().set(this.readBoolean(parameters[2]));
        }
    }

    @Override
    protected List<? extends Object> getFieldValues() {
        return Arrays.asList(this.name().name(), this.size(), this.skipFontsFolder());
    }
}

