/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.resource.fxml;

import java.util.Arrays;
import java.util.List;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.jrebirth.af.api.resource.fxml.FXMLParams;
import org.jrebirth.af.core.resource.AbstractBaseParams;

public class FXML
extends AbstractBaseParams
implements FXMLParams {
    public static final String PATH_SEPARATOR = "/";
    public static final String DOT_SEPARATOR = "\\.";
    public static final String FXML_EXT = ".fxml";
    private final StringProperty absolutePath = new SimpleStringProperty("");
    private final StringProperty absoluteBundlePath = new SimpleStringProperty();
    private final StringProperty fxmlName = new SimpleStringProperty();
    private final StringProperty bundleName = new SimpleStringProperty();

    public FXML(String fxmlPath, String fxmlName, String bundlePath, String bundleName) {
        this.absolutePath.set((Object)fxmlPath.replaceAll(DOT_SEPARATOR, PATH_SEPARATOR));
        this.fxmlName.set((Object)fxmlName);
        this.absoluteBundlePath.set((Object)bundlePath.replaceAll(DOT_SEPARATOR, PATH_SEPARATOR));
        this.bundleName.set((Object)bundleName);
    }

    public FXML(String globalPath, String globalName) {
        this(globalPath, globalName, globalPath, globalName);
    }

    public FXML(String name) {
        this("", name);
    }

    @Override
    public String absolutePath() {
        return (String)this.absolutePath.get();
    }

    public StringProperty absolutePathProperty() {
        return this.absolutePath;
    }

    @Override
    public String fxmlName() {
        return (String)this.fxmlName.get();
    }

    public StringProperty fxmlNameProperty() {
        return this.fxmlName;
    }

    @Override
    public String absoluteBundlePath() {
        return (String)this.absoluteBundlePath.get();
    }

    public StringProperty absoluteBundlePathProperty() {
        return this.absoluteBundlePath;
    }

    @Override
    public String bundleName() {
        return (String)this.bundleName.get();
    }

    public StringProperty bundleNameProperty() {
        return this.bundleName;
    }

    @Override
    public String getFxmlPath() {
        StringBuilder sb = new StringBuilder();
        if (!this.absolutePath().isEmpty()) {
            sb.append(this.absolutePath()).append(PATH_SEPARATOR);
        }
        sb.append(this.fxmlName());
        return sb.toString();
    }

    @Override
    public String getBundlePath() {
        StringBuilder sb = new StringBuilder();
        if (this.bundleName().isEmpty()) {
            sb.append(this.getFxmlPath());
        } else {
            if (!this.absoluteBundlePath().isEmpty()) {
                sb.append(this.absoluteBundlePath()).append(PATH_SEPARATOR);
            }
            sb.append(this.bundleName());
        }
        return sb.toString();
    }

    @Override
    public void parse(String ... parameters) {
        switch (parameters.length) {
            case 4: {
                this.absolutePathProperty().set((Object)parameters[0]);
                this.fxmlNameProperty().set((Object)parameters[1]);
                this.absoluteBundlePathProperty().set((Object)parameters[2]);
                this.bundleNameProperty().set((Object)parameters[3]);
                break;
            }
            case 3: {
                this.absolutePathProperty().set((Object)parameters[0]);
                this.fxmlNameProperty().set((Object)parameters[1]);
                break;
            }
            default: {
                this.fxmlNameProperty().set((Object)parameters[0]);
            }
        }
    }

    @Override
    protected List<? extends Object> getFieldValues() {
        return Arrays.asList(this.absolutePath(), this.fxmlName(), this.absoluteBundlePath(), this.bundleName());
    }
}

