/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.resource.i18n;

import java.text.MessageFormat;
import org.jrebirth.af.api.exception.CoreRuntimeException;
import org.jrebirth.af.api.resource.i18n.JRLevel;
import org.jrebirth.af.api.resource.i18n.MessageItem;
import org.jrebirth.af.api.resource.i18n.MessageParams;
import org.jrebirth.af.api.resource.i18n.MessageResource;
import org.jrebirth.af.core.resource.AbstractResourceItem;
import org.jrebirth.af.core.resource.i18n.MessageBuilder;
import org.jrebirth.af.core.resource.i18n.MessageItemBase;
import org.jrebirth.af.core.resource.provided.parameter.CoreParameters;
import org.slf4j.Marker;

public final class MessageItemImpl
extends AbstractResourceItem<MessageItem, MessageParams, MessageResource>
implements MessageItemBase {
    public static MessageItemImpl create() {
        return new MessageItemImpl();
    }

    @Override
    public String getText(Object ... stringParameters) {
        String res;
        block5: {
            res = this.get().getMessage();
            if (stringParameters.length > 0) {
                try {
                    res = MessageFormat.format(res, stringParameters);
                    if (res.startsWith("<") && res.endsWith(">")) {
                        res = res + " values: ";
                        StringBuilder sb = new StringBuilder();
                        for (Object param : stringParameters) {
                            if (param == null) continue;
                            sb.append(param.toString()).append("|");
                        }
                        res = res + sb.toString();
                    }
                }
                catch (IllegalArgumentException e) {
                    res = "<!!" + ((MessageParams)this.builder().getParam(this)).toString() + "!!>";
                    if (!CoreParameters.DEVELOPER_MODE.get().booleanValue()) break block5;
                    throw new CoreRuntimeException("Bad formatted Message key : " + res, e);
                }
            }
        }
        return res;
    }

    @Override
    public void define(MessageResource forcedValue) {
        ((MessageBuilder)this.builder()).define(this, forcedValue);
    }

    @Override
    public void persist() {
        throw new CoreRuntimeException("Not Implemented yet");
    }

    @Override
    public Marker getMarker() {
        return this.get().getMarker();
    }

    @Override
    public JRLevel getLevel() {
        return this.get().getLevel();
    }

    @Override
    public MessageItem set(MessageParams messageParams) {
        this.builder().storeParams(this, messageParams);
        return this;
    }
}

