/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.resource.i18n;

import org.jrebirth.af.api.resource.i18n.JRLevel;
import org.jrebirth.af.api.resource.i18n.MessageResource;
import org.jrebirth.af.core.log.JRebirthMarkers;
import org.slf4j.Marker;

public class MessageResourceBase
implements MessageResource {
    private String message;
    private Marker marker;
    private JRLevel level;

    public MessageResourceBase(String message) {
        this.message = message;
    }

    public MessageResourceBase(String rawMessage, Marker defaultMarker, JRLevel defaultLevel) {
        String[] messageContent = rawMessage.split("\\|\\|");
        this.message = messageContent[0];
        this.level = messageContent.length >= 2 ? JRLevel.valueOf(messageContent[1]) : defaultLevel;
        if (messageContent.length >= 3) {
            try {
                this.marker = (Marker)JRebirthMarkers.class.getField(messageContent[2]).get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                this.marker = defaultMarker;
            }
        } else {
            this.marker = defaultMarker;
        }
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public Marker getMarker() {
        return this.marker;
    }

    @Override
    public JRLevel getLevel() {
        return this.level;
    }

    public String toString() {
        return this.getMessage();
    }
}

