/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.resource.image;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.text.Text;
import org.jrebirth.af.api.resource.builder.ResourceBuilder;
import org.jrebirth.af.api.resource.image.ImageItem;
import org.jrebirth.af.api.resource.image.ImageParams;
import org.jrebirth.af.core.resource.builder.AbstractResourceBuilder;
import org.jrebirth.af.core.resource.image.AbsImage;
import org.jrebirth.af.core.resource.image.AbstractBaseImage;
import org.jrebirth.af.core.resource.image.RelImage;
import org.jrebirth.af.core.resource.image.WebImage;
import org.jrebirth.af.core.resource.provided.JRebirthImages;
import org.jrebirth.af.core.resource.provided.parameter.ResourceParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImageBuilder
extends AbstractResourceBuilder<ImageItem, ImageParams, Image>
implements ResourceBuilder<ImageItem, ImageParams, Image> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageBuilder.class);

    @Override
    protected Image buildResource(ImageItem imageItem, ImageParams jrImage) {
        Image image = null;
        if (jrImage instanceof RelImage) {
            image = this.buildLocalImage((RelImage)jrImage, false);
        } else if (jrImage instanceof AbsImage) {
            image = this.buildLocalImage((AbsImage)jrImage, true);
        } else if (jrImage instanceof WebImage) {
            image = this.buildWebImage((WebImage)jrImage);
        }
        if (image == null && !"NotAvailableImage".equals(jrImage.name())) {
            image = JRebirthImages.NOT_AVAILABLE.get();
        }
        if (image == null) {
            WritableImage img = new WritableImage(30, 30);
            Text text = new Text();
            text.setText("N/A");
            img = text.snapshot(null, img);
            image = img;
        }
        return image;
    }

    private Image buildLocalImage(AbstractBaseImage jrImage, boolean skipImagesFolder) {
        StringBuilder sb = new StringBuilder();
        if (jrImage.path() != null && !jrImage.path().isEmpty()) {
            sb.append(jrImage.path()).append("/");
        }
        sb.append(jrImage.name());
        if (jrImage.extension() != null) {
            sb.append((Object)jrImage.extension());
        }
        return this.loadImage(sb.toString(), skipImagesFolder);
    }

    private Image buildWebImage(WebImage jrImage) {
        String url = jrImage.getUrl();
        Image image = null;
        if (url == null || url.isEmpty()) {
            LOGGER.error("Image : {} not found !", (Object)url);
        } else {
            image = new Image(url);
        }
        return image;
    }

    private Image loadImage(String resourceName, boolean skipImagesFolder) {
        Image image = null;
        List<String> imagePaths = skipImagesFolder ? Collections.singletonList("") : ResourceParameters.IMAGE_FOLDER.get();
        for (int i = 0; i < imagePaths.size() && image == null; ++i) {
            InputStream imageInputStream;
            String imagePath = imagePaths.get(i);
            if (!imagePath.isEmpty()) {
                imagePath = imagePath + "/";
            }
            if ((imageInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(imagePath + resourceName)) == null) continue;
            image = new Image(imageInputStream);
        }
        if (image == null) {
            LOGGER.error("Image : {} not found into base folder: {}", (Object)resourceName, (Object)ResourceParameters.IMAGE_FOLDER.get());
        }
        return image;
    }
}

