/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.resource.image;

import javafx.scene.image.Image;
import org.jrebirth.af.api.resource.builder.ResourceBuilder;
import org.jrebirth.af.api.resource.image.ImageExtension;
import org.jrebirth.af.api.resource.image.ImageItem;
import org.jrebirth.af.api.resource.image.ImageParams;
import org.jrebirth.af.core.resource.ResourceBuilders;
import org.jrebirth.af.core.resource.image.AbsImage;
import org.jrebirth.af.core.resource.image.RelImage;
import org.jrebirth.af.core.resource.image.WebImage;

public interface ImageItemBase
extends ImageItem {
    @Override
    default public ResourceBuilder<ImageItem, ImageParams, Image> builder() {
        return ResourceBuilders.IMAGE_BUILDER;
    }

    public static interface Web
    extends ImageItemBase {
        default public void web(String website, String path, String name, ImageExtension extension) {
            this.set(new WebImage(website, path, name, extension));
        }

        default public void web(String website, boolean secured, String path, String name, ImageExtension extension) {
            this.set(new WebImage(website, secured, path, name, extension));
        }
    }

    public static interface Absolute
    extends ImageItemBase {
        default public void abs(String path, String name, ImageExtension extension) {
            this.set(new AbsImage(path, name, extension));
        }

        default public void abs(String name, ImageExtension extension) {
            this.set(new AbsImage(name, extension));
        }

        default public void abs(String fullName) {
            this.set(new AbsImage(fullName));
        }
    }

    public static interface Relative
    extends ImageItemBase {
        default public void rel(String path, String name, ImageExtension extension) {
            this.set(new RelImage(path, name, extension));
        }

        default public void rel(String name, ImageExtension extension) {
            this.set(new RelImage(name, extension));
        }

        default public void rel(String fullName) {
            this.set(new RelImage(fullName));
        }
    }
}

