/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.resource.image;

import java.util.Arrays;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.jrebirth.af.api.resource.image.ImageExtension;
import org.jrebirth.af.api.resource.image.ImageParams;
import org.jrebirth.af.core.resource.image.AbstractBaseImage;

public class WebImage
extends AbstractBaseImage
implements ImageParams {
    private final StringProperty websiteProperty = new SimpleStringProperty();
    private final BooleanProperty securedProperty = new SimpleBooleanProperty(Boolean.FALSE.booleanValue());

    public WebImage(String website, String path, String name, ImageExtension extension) {
        super(path, name, extension);
        this.websiteProperty.set((Object)website);
    }

    public WebImage(String website, boolean secured, String path, String name, ImageExtension extension) {
        this(website, path, name, extension);
        this.securedProperty.set(secured);
    }

    public String website() {
        return (String)this.websiteProperty.get();
    }

    public StringProperty websiteProperty() {
        return this.websiteProperty;
    }

    public Boolean secured() {
        return this.securedProperty.get();
    }

    public BooleanProperty securedProperty() {
        return this.securedProperty;
    }

    public String getUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.secured() != false ? "https://" : "http://").append(this.website()).append(this.path()).append(this.name()).append((Object)this.extension());
        return sb.toString();
    }

    @Override
    public void parse(String ... parameters) {
        if (parameters.length == 4) {
            this.websiteProperty().set((Object)parameters[0]);
            this.pathProperty().set((Object)parameters[1]);
            this.nameProperty().set((Object)parameters[2]);
            this.extensionProperty().set((Object)ImageExtension.of(parameters[3]));
        }
        if (parameters.length == 5) {
            this.websiteProperty().set((Object)parameters[0]);
            this.securedProperty().set(this.readBoolean(parameters[1]));
            this.pathProperty().set((Object)parameters[2]);
            this.nameProperty().set((Object)parameters[3]);
            this.extensionProperty().set((Object)ImageExtension.of(parameters[4]));
        }
    }

    @Override
    protected List<? extends Object> getFieldValues() {
        return Arrays.asList(this.website(), this.secured().toString(), this.path(), this.name(), this.extension().toString());
    }
}

