/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.resource.parameter;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jrebirth.af.api.exception.CoreRuntimeException;
import org.jrebirth.af.api.resource.ResourceParams;
import org.jrebirth.af.api.resource.parameter.ParameterParams;
import org.jrebirth.af.core.resource.AbstractBaseParams;
import org.jrebirth.af.core.resource.ParameterEntry;

public class ObjectParameter<O>
extends AbstractBaseParams
implements ParameterParams {
    private final String parameterName;
    private final O object;

    public ObjectParameter(String parameterName, O object) {
        this.object = object;
        this.parameterName = parameterName;
        if (object == null) {
            throw new CoreRuntimeException("ObjectParameter must have a non null object for parameter : " + this.parameterName);
        }
    }

    public String name() {
        return this.parameterName;
    }

    public O object() {
        return this.object;
    }

    public Object parseObject(ParameterEntry parameterEntry) {
        Object res = null;
        if (this.object instanceof ResourceParams) {
            ((ResourceParams)this.object).parse(parameterEntry.getSerializedString().split("\\|\\|"));
            res = this.object;
        } else {
            res = this.object instanceof Class ? this.parseClassParameter(parameterEntry.getSerializedString()) : (this.object instanceof File ? this.parseFileParameter(parameterEntry.getSerializedString()) : (this.object instanceof List ? this.parseListParameter(parameterEntry.getSerializedString()) : this.parsePrimitive(parameterEntry.getSerializedString())));
        }
        parameterEntry.setObject(res);
        return res;
    }

    private Object parseClassParameter(String serializedObject) {
        Class<?> res = null;
        try {
            res = Class.forName(serializedObject);
        }
        catch (ClassNotFoundException e) {
            throw new CoreRuntimeException("Impossible to load class " + serializedObject, e);
        }
        return res;
    }

    private Object parseFileParameter(String serializedObject) {
        File res = new File(serializedObject);
        if (!res.exists()) {
            throw new CoreRuntimeException("Impossible to load file " + serializedObject);
        }
        return res;
    }

    private Object parseListParameter(String serializedObject) {
        ArrayList<String> res = new ArrayList<String>();
        for (String item : serializedObject.split(";")) {
            res.add(item);
        }
        return res;
    }

    private Object parsePrimitive(String serializedObject) {
        Object res = null;
        if (this.object instanceof Boolean) {
            res = Boolean.valueOf(serializedObject);
        } else if (this.object instanceof String) {
            res = serializedObject;
        } else if (this.object instanceof Character) {
            res = Character.valueOf(serializedObject.charAt(0));
        } else if (this.object instanceof Byte) {
            res = Byte.parseByte(serializedObject);
        } else if (this.object instanceof Short) {
            res = Short.parseShort(serializedObject);
        } else if (this.object instanceof Integer) {
            res = Integer.parseInt(serializedObject);
        } else if (this.object instanceof Long) {
            res = Long.parseLong(serializedObject);
        } else if (this.object instanceof Float) {
            res = Float.valueOf(Float.parseFloat(serializedObject));
        } else if (this.object instanceof Double) {
            res = Double.parseDouble(serializedObject);
        }
        return res;
    }

    @Override
    public void parse(String[] string) {
    }

    @Override
    protected List<? extends Object> getFieldValues() {
        return Arrays.asList(this.name());
    }
}

