/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.resource.provided;

import javafx.scene.control.Labeled;
import org.jrebirth.af.api.resource.font.FontExtension;
import org.jrebirth.af.api.resource.font.FontItem;
import org.jrebirth.af.api.resource.font.FontName;
import org.jrebirth.af.core.resource.Resources;
import org.jrebirth.af.core.resource.font.CustomFontName;
import org.jrebirth.af.core.resource.font.RealFont;

public interface IconFont {
    public static FontItem buildItem(Class<? extends IconFont> iconFontClass) {
        return IconFont.buildItem(iconFontClass, FontExtension.TTF);
    }

    public static FontItem buildItem(Class<? extends IconFont> iconFontClass, FontExtension fontExtension) {
        return Resources.create(new RealFont((FontName)new CustomFontName(iconFontClass.getSimpleName()), 16.0, fontExtension));
    }

    public static FontItem buildItem(String fontName, Class<? extends IconFont> iconFontClass, FontExtension fontExtension) {
        return Resources.create(new RealFont((FontName)new CustomFontName(fontName), 16.0, fontExtension));
    }

    default public void use(Labeled l) {
        l.setFont(this.item().get());
        l.setText(this.charCode());
    }

    default public void use(Labeled l, double fontSize) {
        l.setFont(this.item().get(fontSize));
        l.setText(this.charCode());
    }

    public String charCode();

    public FontItem item();

    public String name();
}

