/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.resource.style;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.jrebirth.af.api.resource.builder.ResourceBuilder;
import org.jrebirth.af.api.resource.style.StyleSheetItem;
import org.jrebirth.af.api.resource.style.StyleSheetParams;
import org.jrebirth.af.core.resource.builder.AbstractResourceBuilder;
import org.jrebirth.af.core.resource.provided.parameter.ResourceParameters;
import org.jrebirth.af.core.resource.style.StyleSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StyleSheetBuilder
extends AbstractResourceBuilder<StyleSheetItem, StyleSheetParams, URL>
implements ResourceBuilder<StyleSheetItem, StyleSheetParams, URL> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StyleSheetBuilder.class);
    private static final String CSS_EXT = ".css";

    @Override
    protected URL buildResource(StyleSheetItem ssi, StyleSheetParams ssp) {
        URL cssURL = null;
        if (ssp instanceof StyleSheet) {
            cssURL = this.buildStyleSheetUrl((StyleSheet)ssp);
        }
        return cssURL;
    }

    private URL buildStyleSheetUrl(StyleSheet ss) {
        StringBuilder sb = new StringBuilder();
        if (!ss.path().isEmpty()) {
            sb.append(ss.path()).append("/");
        }
        sb.append(ss.name());
        if (!ss.name().endsWith(CSS_EXT)) {
            sb.append(CSS_EXT);
        }
        return this.buildUrl(sb.toString(), ss.skipStylesFolder());
    }

    private URL buildUrl(String styleSheetPath, boolean skipStylesFolder) {
        URL cssResource = null;
        List<String> stylePaths = skipStylesFolder ? Collections.singletonList("") : ResourceParameters.STYLE_FOLDER.get();
        for (int i = 0; i < stylePaths.size() && cssResource == null; ++i) {
            String stylePath = stylePaths.get(i);
            if (!stylePath.isEmpty()) {
                stylePath = stylePath + "/";
            }
            cssResource = Thread.currentThread().getContextClassLoader().getResource(stylePath + styleSheetPath);
        }
        if (cssResource == null) {
            LOGGER.error("Style Sheet : {} not found into base folder: {}", (Object)styleSheetPath, (Object)ResourceParameters.STYLE_FOLDER.get());
        }
        return cssResource;
    }
}

