/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.service;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.scene.control.ProgressBar;
import org.jrebirth.af.api.exception.CoreException;
import org.jrebirth.af.api.facade.JRebirthEventType;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.api.service.Service;
import org.jrebirth.af.api.service.ServiceTask;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.api.wave.contract.WaveData;
import org.jrebirth.af.core.component.behavior.AbstractBehavioredComponent;
import org.jrebirth.af.core.concurrent.JRebirth;
import org.jrebirth.af.core.log.JRLoggerFactory;
import org.jrebirth.af.core.service.ServiceMessages;
import org.jrebirth.af.core.service.ServiceTaskBase;
import org.jrebirth.af.core.service.ServiceTaskWaveListener;
import org.jrebirth.af.core.util.ClassUtility;
import org.jrebirth.af.core.wave.JRebirthWaves;
import org.jrebirth.af.core.wave.WBuilder;

public abstract class AbstractService
extends AbstractBehavioredComponent<Service>
implements Service,
ServiceMessages {
    private static final String RATIO_SEPARATOR = " / ";
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(AbstractService.class);
    private final ObservableMap<String, ServiceTask<?>> pendingTasks = FXCollections.observableMap(new HashMap());

    @Override
    public final void ready() throws CoreException {
        this.initService();
    }

    protected abstract void initService();

    protected void finalize() throws Throwable {
        this.localFacade().globalFacade().trackEvent(JRebirthEventType.DESTROY_SERVICE, null, this.getClass(), new String[0]);
        super.finalize();
    }

    @Override
    public <T> ServiceTask<T> returnData(Wave sourceWave) {
        ServiceTask<T> task = null;
        try {
            Method method;
            ArrayList parameterValues = new ArrayList();
            for (WaveData<?> wd : sourceWave.waveDatas()) {
                if (!wd.key().isParameter()) continue;
                parameterValues.add(wd.value());
            }
            if (sourceWave.waveType() == null) {
                LOGGER.error(NO_WAVE_TYPE_DEFINED, this.getClass().getSimpleName());
            }
            if ((method = ClassUtility.getMethodByName(this.getClass(), ClassUtility.underscoreToCamelCase(sourceWave.waveType().toString()))) != null) {
                task = this.runTask(sourceWave, method, parameterValues.toArray());
            }
        }
        catch (NoSuchMethodException e) {
            this.processWave(sourceWave);
        }
        return task;
    }

    private <T> ServiceTask<T> runTask(Wave sourceWave, Method method, Object[] parameterValues) {
        sourceWave.addWaveListener(new ServiceTaskWaveListener());
        ServiceTaskBase task = new ServiceTaskBase(this, method, parameterValues, sourceWave);
        this.pendingTasks.put((Object)sourceWave.wUID(), task);
        sourceWave.addDatas(WBuilder.waveData(JRebirthWaves.SERVICE_TASK, task));
        if (sourceWave.containsNotNull(JRebirthWaves.PROGRESS_PROPERTY)) {
            this.bindProgressProperty(task, sourceWave.getData(JRebirthWaves.PROGRESS_PROPERTY).value());
        }
        if (sourceWave.containsNotNull(JRebirthWaves.PROGRESS_BAR)) {
            this.bindProgressBar(task, sourceWave.getData(JRebirthWaves.PROGRESS_BAR).value());
        }
        if (sourceWave.containsNotNull(JRebirthWaves.TASK_TITLE)) {
            this.bindTitle(task, sourceWave.getData(JRebirthWaves.TASK_TITLE).value());
        }
        if (sourceWave.containsNotNull(JRebirthWaves.TASK_MESSAGE)) {
            this.bindMessage(task, sourceWave.getData(JRebirthWaves.TASK_MESSAGE).value());
        }
        JRebirth.runIntoJTP(task);
        return task;
    }

    private void bindProgressProperty(ServiceTaskBase<?> task, DoubleProperty progressProperty) {
        JRebirth.runIntoJAT("Bind Progress Property to " + task.getServiceHandlerName(), () -> {
            task.updateProgress(0L, 0L);
            progressProperty.bind((ObservableValue)task.workDoneProperty().divide((ObservableNumberValue)task.totalWorkProperty()));
        });
    }

    private void bindProgressBar(ServiceTaskBase<?> task, ProgressBar progressBar) {
        JRebirth.runIntoJAT("Bind ProgressBar to " + task.getServiceHandlerName(), () -> {
            task.updateProgress(0L, 0L);
            progressBar.progressProperty().bind((ObservableValue)task.workDoneProperty().divide((ObservableNumberValue)task.totalWorkProperty()));
        });
    }

    private void bindTitle(ServiceTask<?> task, StringProperty titleProperty) {
        JRebirth.runIntoJAT("Bind Title for " + task.getServiceHandlerName(), () -> titleProperty.bind((ObservableValue)task.titleProperty()));
    }

    private void bindMessage(ServiceTask<?> task, StringProperty messageProperty) {
        JRebirth.runIntoJAT("Bind Message for " + task.getServiceHandlerName(), () -> messageProperty.bind((ObservableValue)task.messageProperty()));
    }

    @Override
    public ObservableMap<String, ServiceTask<?>> pendingTasksProperty() {
        return this.pendingTasks;
    }

    @Override
    public Collection<ServiceTask<?>> getPendingTaskList() {
        return this.pendingTasks.values();
    }

    @Override
    public void removePendingTask(String taskKey) {
        this.pendingTasks.remove((Object)taskKey);
    }

    @Override
    public ServiceTask<?> getPendingTask(String taskKey) {
        return (ServiceTask)this.pendingTasks.get((Object)taskKey);
    }

    public void updateProgress(Wave wave, long workDone, long totalWork) {
        this.updateProgress(wave, workDone, totalWork, 1.0);
    }

    public void updateProgress(Wave wave, long workDone, long totalWork, double progressIncrement) {
        if (wave.get(JRebirthWaves.SERVICE_TASK).checkProgressRatio(workDone, totalWork, progressIncrement)) {
            JRebirth.runIntoJAT("ServiceTask Workdone (lng) " + workDone + RATIO_SEPARATOR + totalWork + "[" + workDone * 100L / totalWork + "%]", () -> wave.get(JRebirthWaves.SERVICE_TASK).updateProgress(workDone, totalWork));
        }
    }

    public void updateProgress(Wave wave, double workDone, double totalWork) {
        this.updateProgress(wave, workDone, totalWork, 1.0);
    }

    public void updateProgress(Wave wave, double workDone, double totalWork, double progressIncrement) {
        if (wave.get(JRebirthWaves.SERVICE_TASK).checkProgressRatio(workDone, totalWork, progressIncrement)) {
            JRebirth.runIntoJAT("ServiceTask Workdone (dbl) " + workDone + RATIO_SEPARATOR + totalWork, () -> wave.get(JRebirthWaves.SERVICE_TASK).updateProgress(workDone, totalWork));
        }
    }

    public void updateMessage(Wave wave, String message) {
        JRebirth.runIntoJAT("Service Task Mesage => " + message, () -> wave.get(JRebirthWaves.SERVICE_TASK).updateMessage(message));
    }

    public void updateTitle(Wave wave, String title) {
        JRebirth.runIntoJAT("Service Task Title => " + title, () -> wave.get(JRebirthWaves.SERVICE_TASK).updateTitle(title));
    }
}

