/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.service.basic;

import org.jrebirth.af.api.concurrent.RunInto;
import org.jrebirth.af.api.concurrent.RunType;
import org.jrebirth.af.api.service.Service;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.api.wave.annotation.OnWave;
import org.jrebirth.af.api.wave.contract.WaveType;
import org.jrebirth.af.core.wave.JRebirthItems;
import org.jrebirth.af.core.wave.WBuilder;

public interface StageService
extends Service {
    public static final String STAGE_OPENED = "STAGE_OPENED";
    public static final String STAGE_CLOSED = "STAGE_CLOSED";
    public static final String STAGE_DESTROYED = "STAGE_DESTROYED";
    public static final String DESTROY_STAGE = "DESTROY_STAGE";
    public static final String CLOSE_STAGE = "CLOSE_STAGE";
    public static final String OPEN_STAGE = "OPEN_STAGE";
    public static final WaveType DO_OPEN_STAGE = WBuilder.waveTypeDo("OPEN_STAGE").returnAction("STAGE_OPENED").returnItem(JRebirthItems.voidItem);
    public static final WaveType DO_CLOSE_STAGE = WBuilder.waveTypeDo("CLOSE_STAGE").returnAction("STAGE_CLOSED").returnItem(JRebirthItems.voidItem);
    public static final WaveType DO_DESTROY_STAGE = WBuilder.waveTypeDo("DESTROY_STAGE").returnAction("STAGE_DESTROYED").returnItem(JRebirthItems.voidItem);

    @OnWave(value="OPEN_STAGE")
    @RunInto(value=RunType.JAT)
    public void doOpenStage(Wave var1);

    @OnWave(value="CLOSE_STAGE")
    @RunInto(value=RunType.JAT)
    public void doCloseStage(Wave var1);

    @OnWave(value="DESTROY_STAGE")
    @RunInto(value=RunType.JAT)
    public void doDestroyStage(Wave var1);

    public static interface StageAware
    extends StageOpenedAware,
    StageClosedAware,
    StageDestroyedAware {
    }

    public static interface StageDestroyedAware {
        @OnWave(value="STAGE_DESTROYED")
        public void doStageDestroyed(Wave var1);
    }

    public static interface StageClosedAware {
        @OnWave(value="STAGE_CLOSED")
        public void doStageClosed(Wave var1);
    }

    public static interface StageOpenedAware {
        @OnWave(value="STAGE_OPENED")
        public void doStageOpened(Wave var1);
    }
}

