/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.service.basic.impl;

import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import org.jrebirth.af.api.concurrent.RunInto;
import org.jrebirth.af.api.concurrent.RunType;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.core.command.basic.stage.StageWaveBean;
import org.jrebirth.af.core.service.DefaultService;
import org.jrebirth.af.core.service.basic.StageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StageServiceImpl
extends DefaultService
implements StageService {
    private static final Logger LOGGER = LoggerFactory.getLogger(StageServiceImpl.class);
    private final Map<String, Stage> stageMap = new HashMap<String, Stage>();

    @Override
    public void initService() {
    }

    @Override
    @RunInto(value=RunType.JAT)
    public void doOpenStage(Wave wave) {
        LOGGER.trace("Open a stage.");
        StageWaveBean swb = this.getWaveBean(wave);
        String stageKey = swb.stageKey();
        if (this.stageMap.containsKey(stageKey) && this.stageMap.get(stageKey) != null) {
            Platform.runLater(() -> this.stageMap.get(stageKey).show());
        } else {
            Region rootPane = this.getRootPane(swb);
            Scene scene = this.getScene(swb, rootPane);
            Stage stage = this.getStage(swb, scene);
            this.stageMap.put(stageKey, stage);
            Platform.runLater(() -> stage.show());
        }
    }

    private Region getRootPane(StageWaveBean swb) {
        return swb.rootPane() == null ? new StackPane() : swb.rootPane();
    }

    private Scene getScene(StageWaveBean swb, Region region) {
        Scene scene = swb.scene();
        if (scene == null) {
            scene = new Scene((Parent)region);
        } else {
            scene.setRoot((Parent)region);
        }
        return scene;
    }

    private Stage getStage(StageWaveBean swb, Scene scene) {
        Stage stage = swb.stage();
        if (stage == null) {
            stage = new Stage();
        }
        stage.setScene(scene);
        return stage;
    }

    @Override
    public void doCloseStage(Wave wave) {
        String stageKey = this.getWaveBean(wave).stageKey();
        Platform.runLater(() -> this.stageMap.get(stageKey).close());
    }

    @Override
    public void doDestroyStage(Wave wave) {
        String stageKey = this.getWaveBean(wave).stageKey();
        Platform.runLater(() -> this.stageMap.get(stageKey).close());
        this.stageMap.remove(stageKey);
    }

    public StageWaveBean getWaveBean(Wave wave) {
        return wave.waveBean(StageWaveBean.class);
    }

    public Stage getStage(String stageKey) {
        return this.stageMap.get(stageKey);
    }
}

