/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import org.jrebirth.af.api.exception.CoreException;
import org.jrebirth.af.api.facade.JRebirthEventType;
import org.jrebirth.af.api.ui.Controller;
import org.jrebirth.af.api.ui.Model;
import org.jrebirth.af.api.ui.View;
import org.jrebirth.af.core.ui.adapter.AbstractDefaultAdapter;
import org.jrebirth.af.core.ui.adapter.EventAdapter;

public abstract class AbstractBaseController<M extends Model, V extends View<M, ?, ?>>
implements Controller<M, V>,
EventAdapter {
    private final transient V view;
    private final Map<EventType<? extends Event>, EventHandler<? extends Event>> eventHandlerMap = new HashMap<EventType<? extends Event>, EventHandler<? extends Event>>();

    public AbstractBaseController(V view) throws CoreException {
        this.view = view;
        this.model().localFacade().globalFacade().trackEvent(JRebirthEventType.CREATE_CONTROLLER, this.view().getClass(), this.getClass(), new String[0]);
    }

    @Override
    public final void activate() throws CoreException {
        this.initInternalEventAdapters();
        this.initInternalEventHandlers();
    }

    protected final void initInternalEventAdapters() throws CoreException {
        this.initEventAdapters();
    }

    protected abstract void initEventAdapters() throws CoreException;

    protected final void initInternalEventHandlers() throws CoreException {
        this.initEventHandlers();
    }

    protected abstract void initEventHandlers() throws CoreException;

    @Override
    public final V view() {
        return this.view;
    }

    @Override
    public final M model() {
        return this.view().model();
    }

    @Override
    public final Node node() {
        return this.view().node();
    }

    protected final void addAdapter(EventAdapter eventAdapter) throws CoreException {
        if (eventAdapter instanceof AbstractDefaultAdapter) {
            ((AbstractDefaultAdapter)eventAdapter).controller(this);
        }
        for (EventAdapter.Linker linker : EventAdapter.Linker.values()) {
            if (!linker.adapterClass().isAssignableFrom(eventAdapter.getClass())) continue;
            this.eventHandlerMap.put(linker.eventType(), this.wrapbuildHandler(eventAdapter, linker.adapterClass(), linker.handlerClass()));
        }
    }

    protected final <E extends Event> EventHandler<E> getHandler(EventType<E> eventType) throws CoreException {
        Object handler = null;
        for (EventType temp = eventType; temp != null && handler == null; temp = temp.getSuperType()) {
            handler = this.eventHandlerMap.get(temp);
        }
        if (handler == null) {
            for (EventAdapter.Linker linker : EventAdapter.Linker.values()) {
                if (!this.isEventType((EventType<Event>)eventType, linker.eventType())) continue;
                handler = this.buildEventHandler(linker.adapterClass(), linker.handlerClass());
            }
            if (handler != null) {
                this.eventHandlerMap.put((EventType<? extends Event>)eventType, (EventHandler<? extends Event>)handler);
            }
        }
        return handler;
    }

    private <E extends Event> EventHandler<E> wrapbuildHandler(EventAdapter eventAdapter, Class<? extends EventAdapter> adapterClass, Class<? extends EventHandler<E>> handlerClass) throws CoreException {
        try {
            return handlerClass.getDeclaredConstructor(adapterClass).newInstance(eventAdapter);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new CoreException("Impossible to build event handler " + handlerClass.getName() + " for the class " + this.getClass().getName(), (Throwable)e);
        }
    }

    private <E extends Event> EventHandler<E> buildEventHandler(Class<? extends EventAdapter> adapterClass, Class<? extends EventHandler<E>> handlerClass) throws CoreException {
        EventHandler<E> eventHandler = null;
        if (!adapterClass.isAssignableFrom(this.getClass())) {
            throw new CoreException(this.getClass().getName() + " must implement " + adapterClass.getName() + " interface");
        }
        eventHandler = this.wrapbuildHandler(this, adapterClass, handlerClass);
        return eventHandler;
    }

    private boolean isEventType(EventType<? extends Event> testEventType, EventType<? extends Event> anyEventType) {
        return testEventType.equals(anyEventType) || testEventType.getSuperType().equals(anyEventType);
    }

    protected void finalize() throws Throwable {
        this.model().localFacade().globalFacade().trackEvent(JRebirthEventType.DESTROY_CONTROLLER, null, this.getClass(), new String[0]);
        super.finalize();
    }
}

