/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.ui;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import org.jrebirth.af.api.concurrent.RunType;
import org.jrebirth.af.api.exception.CoreException;
import org.jrebirth.af.api.facade.JRebirthEventType;
import org.jrebirth.af.api.ui.Model;
import org.jrebirth.af.api.ui.annotation.AutoRelease;
import org.jrebirth.af.api.ui.annotation.CreateViewIntoJAT;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.core.component.behavior.AbstractBehavioredComponent;
import org.jrebirth.af.core.concurrent.JRebirth;
import org.jrebirth.af.core.util.ClassUtility;

public abstract class AbstractBaseModel<M extends Model>
extends AbstractBehavioredComponent<Model>
implements Model {
    private boolean viewDisplayed;
    protected boolean createViewIntoJAT;
    protected boolean hasBeenAttached = false;

    public AbstractBaseModel() {
        CreateViewIntoJAT cvij = this.getClass().getAnnotation(CreateViewIntoJAT.class);
        this.createViewIntoJAT = cvij == null ? false : cvij.value();
    }

    @Override
    protected final void ready() throws CoreException {
        this.initInternalModel();
        JRebirth.run(this.createViewIntoJAT ? RunType.JAT_SYNC : RunType.SAME, this::prepareView, new long[0]);
        this.attachParentListener();
        this.bindInternal();
    }

    protected abstract void prepareView();

    protected abstract void initInternalModel() throws CoreException;

    protected abstract void initModel();

    protected abstract void bindInternal();

    protected abstract void bind();

    protected abstract void unbindInternal();

    protected abstract void unbind();

    protected final void showInternalView(Wave wave) {
        this.showView();
        if (this.view() != null) {
            if (this.viewDisplayed) {
                this.view().reload();
            } else {
                this.view().start();
                this.viewDisplayed = true;
            }
        }
        if (this.getInnerComponentMap().isPresent()) {
            this.getInnerComponentMap().get().values().stream().filter(s -> s instanceof Model).forEach(model -> ((Model)model).doShowView(wave));
        }
    }

    protected abstract void showView();

    protected final void hideInternalView(Wave wave) {
        this.hideView();
        if (this.view() != null) {
            this.view().hide();
        }
        if (this.getInnerComponentMap().isPresent()) {
            this.getInnerComponentMap().get().values().stream().filter(s -> s instanceof Model).forEach(model -> ((Model)model).doHideView(wave));
        }
    }

    protected abstract void hideView();

    @Override
    public Node node() {
        return this.view() == null ? null : this.view().pane();
    }

    @Override
    protected abstract void processWave(Wave var1);

    protected void finalize() throws Throwable {
        this.localFacade().globalFacade().trackEvent(JRebirthEventType.DESTROY_MODEL, null, this.getClass(), new String[0]);
        super.finalize();
    }

    protected void attachParentListener() {
        AutoRelease ar = ClassUtility.getLastClassAnnotation(this.getClass(), AutoRelease.class);
        if (ar != null && ar.value() && this.node() != null) {
            this.node().parentProperty().addListener((ChangeListener)new ChangeListener<Node>(){

                public void changed(ObservableValue<? extends Node> observable, Node oldValue, Node newValue) {
                    if (newValue != null) {
                        AbstractBaseModel.this.hasBeenAttached = true;
                    }
                    if (newValue == null && AbstractBaseModel.this.hasBeenAttached) {
                        AbstractBaseModel.this.hasBeenAttached = false;
                        AbstractBaseModel.this.release();
                        AbstractBaseModel.this.node().parentProperty().removeListener((ChangeListener)this);
                    }
                }
            });
        }
    }
}

