/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.ui;

import java.util.Optional;
import java.util.function.Supplier;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.util.Callback;
import org.jrebirth.af.api.command.Command;
import org.jrebirth.af.api.command.CommandBean;
import org.jrebirth.af.api.exception.CoreException;
import org.jrebirth.af.api.exception.CoreRuntimeException;
import org.jrebirth.af.api.service.Service;
import org.jrebirth.af.api.ui.Model;
import org.jrebirth.af.api.ui.View;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.api.wave.WaveBean;
import org.jrebirth.af.api.wave.contract.WaveData;
import org.jrebirth.af.api.wave.contract.WaveItem;
import org.jrebirth.af.api.wave.contract.WaveType;
import org.jrebirth.af.core.resource.provided.parameter.CoreParameters;
import org.jrebirth.af.core.ui.AbstractBaseController;
import org.jrebirth.af.core.ui.adapter.EventAdapter;
import org.jrebirth.af.core.ui.handler.AbstractNamedEventHandler;
import org.jrebirth.af.core.util.ClassUtility;
import org.jrebirth.af.core.wave.JRebirthWaves;

public abstract class AbstractController<M extends Model, V extends View<M, ?, ?>>
extends AbstractBaseController<M, V> {
    public AbstractController(V view) throws CoreException {
        super(view);
    }

    protected <E extends Event> void linkWave(Node node, EventType<E> eventType, WaveType waveType, WaveData<?> ... waveData) {
        this.linkWave(node, eventType, waveType, (Callback<E, Boolean>)null, waveData);
    }

    protected <E extends Event> void linkWave(Node node, EventType<E> eventType, final WaveType waveType, final Callback<E, Boolean> callback, final WaveData<?> ... waveData) {
        node.addEventHandler(eventType, (EventHandler)new AbstractNamedEventHandler<E, EventAdapter>("LinkWave", null){

            public void handle(E event) {
                if (callback == null || ((Boolean)callback.call(event)).booleanValue()) {
                    AbstractController.this.model().sendWave(waveType, waveData);
                }
            }
        });
    }

    protected <E extends Event> void linkCommand(Node node, EventType<E> eventType, Class<? extends Command> commandClass, WaveData<?> ... waveData) {
        this.linkCommand(node, eventType, commandClass, (Callback<E, Boolean>)null, waveData);
    }

    protected <E extends Event> void linkCommand(Node node, EventType<E> eventType, Class<? extends Command> commandClass, Callback<E, Boolean> callback, WaveData<?> ... waveData) {
        node.addEventHandler(eventType, event -> {
            if (callback == null || ((Boolean)callback.call((Object)event)).booleanValue()) {
                this.model().callCommand(commandClass, waveData);
            }
        });
    }

    protected <E extends Event> void linkUi(Node node, EventType<E> eventType, Class<? extends Model> modelClass, WaveData<?> ... waveData) {
        this.linkUi(node, eventType, modelClass, (Callback<E, Boolean>)null, waveData);
    }

    protected <E extends Event> void linkUi(Node node, EventType<E> eventType, Class<? extends Model> modelClass, Callback<E, Boolean> callback, WaveData<?> ... waveData) {
        boolean noHookFound = true;
        for (int i = 0; i < waveData.length && noHookFound; ++i) {
            WaveData<?> wd = waveData[i];
            if (!JRebirthWaves.ATTACH_UI_NODE_PLACEHOLDER.equals(wd.key()) && !JRebirthWaves.ADD_UI_CHILDREN_PLACEHOLDER.equals(wd.key()) || wd.value() == null) continue;
            noHookFound = false;
        }
        if (noHookFound) {
            throw new CoreRuntimeException("LinkUi must be called with either JRebirthWaves.ATTACH_UI_NODE_PLACEHOLDER or JRebirthWaves.ADD_UI_CHILDREN_PLACEHOLDER Wave Data provided");
        }
        node.addEventHandler(eventType, event -> {
            if (callback == null || ((Boolean)callback.call((Object)event)).booleanValue()) {
                this.model().attachUi((Class<Model>)modelClass, waveData);
            }
        });
    }

    protected <E extends Event> void linkService(Node node, EventType<E> eventType, Class<? extends Service> serviceClass, WaveType waveType, WaveData<?> ... waveData) {
        this.linkService(node, eventType, serviceClass, waveType, (Callback<E, Boolean>)null, waveData);
    }

    protected <E extends Event> void linkService(Node node, EventType<E> eventType, Class<? extends Service> serviceClass, WaveType waveType, Callback<E, Boolean> callback, WaveData<?> ... waveData) {
        node.addEventHandler(eventType, event -> {
            if (callback == null || ((Boolean)callback.call((Object)event)).booleanValue()) {
                this.model().returnData((Class<Service>)serviceClass, waveType, waveData);
            }
        });
    }

    protected Wave callCommand(Class<? extends Command> commandClass, WaveData<?> ... data) {
        return this.model().callCommand(commandClass, data);
    }

    protected Wave callCommand(Class<? extends CommandBean<? extends WaveBean>> commandClass, WaveBean waveBean, WaveBean ... waveBeans) {
        return this.model().callCommand(commandClass, waveBean, waveBeans);
    }

    protected <T> Optional<T> getUserData(Optional<? extends Node> node, WaveItem<T> waveItem) {
        if (node.isPresent()) {
            Node n = node.get();
            return this.getValue((Object)n, () -> ((Node)n).getUserData(), waveItem);
        }
        return Optional.empty();
    }

    protected <T> Optional<T> getUserData(Optional<? extends Node> node, Class<T> type) {
        if (node.isPresent()) {
            Node n = node.get();
            return this.getValue((Object)n, () -> ((Node)n).getUserData(), type);
        }
        return Optional.empty();
    }

    protected <T> Optional<T> getSource(Event event, Class<T> type) {
        return this.getValue((Object)event, () -> event.getSource(), type);
    }

    protected <T> Optional<T> getTarget(Event event, Class<T> type) {
        return this.getValue((Object)event, () -> ((Event)event).getTarget(), type);
    }

    private <T> Optional<T> getValue(Object object, Supplier<Object> method, Class<T> cls) {
        Object source = null;
        if (cls.isInstance(method.get())) {
            source = method.get();
        } else if (CoreParameters.DEVELOPER_MODE.get().booleanValue()) {
            throw new CoreRuntimeException("Cannot cast object " + method.get() + " to " + cls.toGenericString());
        }
        return Optional.ofNullable(source);
    }

    private <T> Optional<T> getValue(Object object, Supplier<Object> method, WaveItem<T> waveItem) {
        Object source = null;
        if (ClassUtility.getClassFromType(waveItem.type()).isInstance(method.get())) {
            source = method.get();
        } else if (CoreParameters.DEVELOPER_MODE.get().booleanValue()) {
            throw new CoreRuntimeException("Cannot cast object " + method.get() + " to " + waveItem.type().toString());
        }
        return Optional.ofNullable(source);
    }
}

