/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.ui;

import java.util.List;
import org.jrebirth.af.api.annotation.OnRelease;
import org.jrebirth.af.api.exception.CoreException;
import org.jrebirth.af.api.exception.CoreRuntimeException;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.api.ui.Model;
import org.jrebirth.af.api.ui.NullView;
import org.jrebirth.af.api.ui.View;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.core.log.JRLoggerFactory;
import org.jrebirth.af.core.ui.AbstractBaseModel;
import org.jrebirth.af.core.ui.UIMessages;
import org.jrebirth.af.core.ui.object.ModelConfig;
import org.jrebirth.af.core.util.ClassUtility;

public abstract class AbstractModel<M extends Model, V extends View<?, ?, ?>>
extends AbstractBaseModel<M> {
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(AbstractModel.class);
    private transient V view;

    @Override
    protected void prepareView() {
        try {
            if (this.view() != null) {
                this.view().prepare();
            }
        }
        catch (CoreException ce) {
            throw new CoreRuntimeException(ce);
        }
    }

    @Override
    protected void initInternalModel() throws CoreException {
        if (this.key().value() instanceof ModelConfig) {
            this.applyStyle((ModelConfig)this.key().value());
        }
        if (this.key().value() instanceof List) {
            for (Object data : (List)this.key().value()) {
                if (!(data instanceof ModelConfig)) continue;
                this.applyStyle((ModelConfig)this.key().value());
            }
        }
        for (Object data : this.key().optionalData()) {
            if (!(data instanceof ModelConfig)) continue;
            this.applyStyle((ModelConfig)data);
        }
        this.initModel();
    }

    protected void applyStyle(ModelConfig<?, ?> mc) {
        if (!"Undetermined".equals(mc.id())) {
            this.node().setId(mc.id());
        }
        if (!"Undetermined".equals(mc.style())) {
            this.node().setStyle(mc.style());
        }
        if (!"Undetermined".equals(mc.styleClass())) {
            this.node().getStyleClass().addAll((Object[])mc.styleClass().split(" "));
        }
    }

    @Override
    public final void doShowView(Wave wave) {
        this.showInternalView(wave);
    }

    @Override
    public final void doHideView(Wave wave) {
        this.hideInternalView(wave);
    }

    @Override
    protected void bindInternal() {
        this.bind();
    }

    @Override
    @OnRelease
    protected void unbindInternal() {
        this.unbind();
    }

    public final V view() {
        if (this.view == null) {
            try {
                this.view = this.buildView();
            }
            catch (CoreException ce) {
                LOGGER.log(UIMessages.CREATION_FAILURE, ce, this.getClass().getName());
                throw new CoreRuntimeException(ce);
            }
        }
        return this.view;
    }

    protected V buildView() throws CoreException {
        return (V)((View)ClassUtility.findAndBuildGenericType(this.getClass(), View.class, NullView.class, this));
    }
}

