/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.ui;

import java.util.stream.Stream;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TouchEvent;
import javafx.util.Callback;

public interface EventFilter {
    public static final Callback<MouseEvent, Boolean> CHECK_MOUSE_SINGLE_CLICK = EventFilter._clickCount(1);
    public static final Callback<MouseEvent, Boolean> CHECK_MOUSE_DOUBLE_CLICK = EventFilter._clickCount(2);

    public static Callback<MouseEvent, Boolean> _clickCount(int nb) {
        return event -> event.getClickCount() == nb;
    }

    default public Callback<MouseEvent, Boolean> clickCount(int nb) {
        return EventFilter._clickCount(nb);
    }

    default public Callback<TouchEvent, Boolean> touchCount(int nb) {
        return event -> event.getTouchCount() == nb;
    }

    default public Callback<KeyEvent, Boolean> allowedKeys(KeyCode ... codes) {
        return event -> Stream.of(codes).anyMatch(kc -> kc == event.getCode());
    }

    default public Callback<KeyEvent, Boolean> forbiddenKeys(KeyCode ... codes) {
        return event -> !Stream.of(codes).anyMatch(kc -> kc == event.getCode());
    }

    default public <E extends Event> EventHandler<E> handleIf(Callback<E, Boolean> callback, EventHandler<E> handler) {
        return event -> {
            if (((Boolean)callback.call((Object)event)).booleanValue()) {
                handler.handle(event);
            }
        };
    }

    default public <E extends Event> EventHandler<E> handleIf(Callback<E, Boolean> callback, Runnable handler) {
        return event -> {
            if (((Boolean)callback.call((Object)event)).booleanValue()) {
                handler.run();
            }
        };
    }
}

