/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.ui.fxml;

import javafx.scene.Node;
import org.jrebirth.af.api.resource.fxml.FXMLItem;
import org.jrebirth.af.api.ui.Model;
import org.jrebirth.af.api.ui.NullView;
import org.jrebirth.af.api.ui.fxml.FXMLComponent;
import org.jrebirth.af.api.ui.fxml.FXMLController;
import org.jrebirth.af.api.ui.fxml.FXMLModel;
import org.jrebirth.af.core.ui.fxml.FXMLUtils;
import org.jrebirth.af.core.ui.object.AbstractObjectModel;

public abstract class AbstractFXMLObjectModel<M extends Model, O>
extends AbstractObjectModel<M, NullView, O>
implements FXMLModel {
    private String fxmlPath;
    private String resourcePath;
    private FXMLItem fxmlItem;
    private FXMLComponent fxmlComponent;

    protected FXMLItem getFXMLItem() {
        return this.fxmlItem;
    }

    protected String getFXMLPath() {
        return this.fxmlPath;
    }

    protected String getFXMLBundlePath() {
        return this.resourcePath;
    }

    @Override
    protected void prepareView() {
        this.fxmlPreInitialize();
        if (this.getFXMLItem() != null) {
            this.fxmlComponent = this.getFXMLItem().get();
            if (this.fxmlComponent.controller() != null) {
                this.fxmlComponent.controller().model(this);
            }
        } else if (this.getFXMLPath() != null) {
            this.fxmlComponent = FXMLUtils.loadFXML(this, this.getFXMLPath(), this.getFXMLBundlePath());
        }
    }

    @Override
    protected final void bindInternal() {
        this.bind();
    }

    protected void fxmlPreInitialize() {
        if (!this.getListKeyPart().isEmpty() && this.getListKeyPart().get(0) instanceof FXMLItem) {
            this.fxmlItem = (FXMLItem)this.getListKeyPart().get(0);
        } else if (!this.getListKeyPart().isEmpty() && this.getListKeyPart().get(0).toString().startsWith("fxml:")) {
            String baseName = this.getListKeyPart().get(0).toString().substring("fxml:".length());
            this.fxmlPath = baseName.replaceAll("\\.", "/") + ".fxml";
            this.resourcePath = this.getListKeyPart().size() > 1 && this.getListKeyPart().get(1).toString().startsWith("rb:") ? this.getListKeyPart().get(1).toString().substring("rb:".length()).replaceAll("\\.", "/") : baseName;
        } else {
            String baseName = this.getClass().getCanonicalName();
            baseName = baseName.substring(0, baseName.lastIndexOf(Model.class.getSimpleName()));
            baseName = baseName.replaceAll("\\.", "/");
            this.fxmlPath = baseName + ".fxml";
            this.resourcePath = baseName;
        }
    }

    @Override
    public Node node() {
        return this.fxmlComponent.node();
    }

    public FXMLController<M, ?> getFXMLController() {
        return this.fxmlComponent.controller();
    }
}

