/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.ui.handler;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import org.jrebirth.af.api.exception.CoreException;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.api.ui.annotation.type.Action;
import org.jrebirth.af.api.ui.annotation.type.EnumEventType;
import org.jrebirth.af.api.ui.annotation.type.Key;
import org.jrebirth.af.core.log.JRLoggerFactory;
import org.jrebirth.af.core.resource.provided.parameter.CoreParameters;
import org.jrebirth.af.core.ui.UIMessages;
import org.jrebirth.af.core.ui.adapter.EventAdapter;
import org.jrebirth.af.core.ui.handler.AbstractNamedEventHandler;
import org.jrebirth.af.core.util.ClassUtility;

public class AnnotationEventHandler<E extends Event>
extends AbstractNamedEventHandler<E, EventAdapter>
implements EventHandler<E>,
UIMessages {
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(AnnotationEventHandler.class);
    private final Annotation annotation;
    private final Object callbackObject;

    public AnnotationEventHandler(Object callbackObject, Annotation annotation) throws CoreException {
        super(AnnotationEventHandler.class.getSimpleName() + "-" + annotation.annotationType().getName(), null);
        this.callbackObject = callbackObject;
        this.annotation = annotation;
        if (CoreParameters.DEVELOPER_MODE.get().booleanValue()) {
            this.checkCallbackMethods();
        }
    }

    private void checkCallbackMethods() throws CoreException {
        for (EnumEventType eet : this.getAnnotationValue()) {
            String methodName = this.buildHandlingMethodName(eet);
            Class<Event> eventClass = this.getAnnotationApiEventClass();
            try {
                this.callbackObject.getClass().getDeclaredMethod(methodName, eventClass);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new CoreException(NO_EVENT_CALLBACK.getText(this.callbackObject.getClass().getName(), methodName, eventClass.getName()), (Throwable)e);
            }
        }
    }

    public void handle(Event event) {
        String methodName = this.buildHandlingMethodName(this.convertEventToEnum((EventType<Event>)event.getEventType()));
        if (!methodName.isEmpty()) {
            this.callMethod(methodName, event);
        }
    }

    private String buildHandlingMethodName(EnumEventType annotationType) {
        StringBuilder methodName = new StringBuilder();
        if (Arrays.asList(this.getAnnotationValue()).contains(annotationType)) {
            methodName.append(this.annotation.annotationType().getSimpleName().substring(0, 1).toLowerCase());
            methodName.append(this.annotation.annotationType().getSimpleName().substring(1));
            methodName.append(Key.Any.name().equals(annotationType.toString()) || Action.Action.name().equals(annotationType.toString()) ? "" : annotationType.name());
            String uniqueName = this.getAnnotationName();
            if (uniqueName.length() > 0) {
                methodName.append(uniqueName);
            }
        }
        return methodName.toString();
    }

    private String getAnnotationName() {
        return ClassUtility.getAnnotationAttribute(this.annotation, "name").toString();
    }

    private EnumEventType[] getAnnotationValue() {
        return (EnumEventType[])ClassUtility.getAnnotationAttribute(this.annotation, "value");
    }

    private Class<Event> getAnnotationApiEventClass() {
        return (Class)ClassUtility.getAnnotationAttribute(this.annotation, "apiEventClass");
    }

    private EnumEventType convertEventToEnum(EventType<? extends Event> eventType) {
        EnumEventType convertedType = null;
        if (this.getAnnotationValue() != null && this.getAnnotationValue().length > 0) {
            EnumEventType[] aTypes = (EnumEventType[])this.getAnnotationValue()[0].getClass().getEnumConstants();
            for (int i = 0; i < aTypes.length && convertedType == null; ++i) {
                if (aTypes[i].eventType() != eventType) continue;
                convertedType = aTypes[i];
            }
        }
        return convertedType;
    }

    private void callMethod(String methodName, Event event) {
        Class<?> ctrlClass = this.callbackObject.getClass();
        try {
            Method method = ctrlClass.getDeclaredMethod(methodName, event.getClass());
            ClassUtility.callMethod(method, this.callbackObject, event);
        }
        catch (IllegalArgumentException | NoSuchMethodException | SecurityException | CoreException e) {
            LOGGER.log(EVENT_HANDLING_IMPOSSIBLE, e);
        }
    }
}

