/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.util;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jrebirth.af.api.component.basic.Component;
import org.jrebirth.af.api.exception.CoreRuntimeException;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.api.wave.annotation.OnWave;
import org.jrebirth.af.api.wave.contract.WaveItem;
import org.jrebirth.af.api.wave.contract.WaveType;
import org.jrebirth.af.core.log.JRLoggerFactory;
import org.jrebirth.af.core.resource.provided.parameter.CoreParameters;
import org.jrebirth.af.core.util.ClassUtility;
import org.jrebirth.af.core.util.UtilMessages;
import org.jrebirth.af.core.wave.WaveTypeRegistry;

public final class CheckerUtility
implements UtilMessages {
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(CheckerUtility.class);

    private CheckerUtility() {
    }

    public static void checkWaveTypeContract(Class<? extends Component> waveReadyClass, WaveType ... waveTypes) {
        if (CoreParameters.DEVELOPER_MODE.get().booleanValue()) {
            for (WaveType waveType : waveTypes) {
                int j;
                String methodName = ClassUtility.underscoreToCamelCase(waveType.toString());
                List<Method> methods = ClassUtility.retrieveMethodList(waveReadyClass, waveType.toString());
                List annotatedMethods = ClassUtility.getAnnotatedMethods(waveReadyClass, OnWave.class).stream().filter(m -> WaveTypeRegistry.getWaveType(m.getAnnotation(OnWave.class).value()) == waveType).collect(Collectors.toList());
                if (methods.isEmpty() && annotatedMethods.isEmpty()) {
                    LOGGER.log(BROKEN_API_NO_METHOD, waveReadyClass.getSimpleName(), methodName);
                    LOGGER.log(WAVE_HANDLER_METHOD_REQUIRED, waveReadyClass.getSimpleName(), methodName, waveType.items());
                }
                int methodParameters = 0;
                boolean hasCompliantMethod = false;
                List<WaveItem<?>> wParams = waveType.parameters();
                for (j = 0; j < methods.size() && !hasCompliantMethod; ++j) {
                    hasCompliantMethod = CheckerUtility.checkMethodSignature(methods.get(j), wParams);
                    if (hasCompliantMethod) continue;
                    methodParameters = methods.get(j).getParameterTypes().length - 1;
                }
                if (!hasCompliantMethod) {
                    for (j = 0; j < annotatedMethods.size() && !hasCompliantMethod; ++j) {
                        hasCompliantMethod = CheckerUtility.checkMethodSignature((Method)annotatedMethods.get(j), wParams);
                        if (hasCompliantMethod) continue;
                        methodName = ((Method)annotatedMethods.get(j)).getName();
                        methodParameters = ((Method)annotatedMethods.get(j)).getParameterTypes().length - 1;
                    }
                }
                if (hasCompliantMethod) continue;
                LOGGER.log(BROKEN_API_WRONG_PARAMETERS, waveReadyClass.getSimpleName(), methodName, waveType.items().size(), methodParameters);
                LOGGER.log(WAVE_HANDLER_METHOD_REQUIRED, waveReadyClass.getSimpleName(), methodName, waveType.items());
            }
        }
    }

    public static boolean checkMethodSignature(Method method, List<WaveItem<?>> wParams) {
        boolean isCompliant = false;
        Type[] mParams = method.getGenericParameterTypes();
        if (wParams.isEmpty() && Wave.class.isAssignableFrom(ClassUtility.getClassFromType(mParams[0]))) {
            isCompliant = true;
        } else if (mParams.length - 1 == wParams.size()) {
            boolean skipMethod = false;
            for (int i = 0; !skipMethod && i < mParams.length - 1 && !isCompliant; ++i) {
                if (!ClassUtility.getClassFromType(mParams[i]).isAssignableFrom(ClassUtility.getClassFromType(wParams.get(i).type()))) {
                    skipMethod = true;
                }
                if (i != mParams.length - 2 || !Wave.class.isAssignableFrom(ClassUtility.getClassFromType(mParams[i + 1]))) continue;
                isCompliant = true;
            }
        }
        return isCompliant;
    }

    public static void checkWave(Wave wave) {
        if (CoreParameters.DEVELOPER_MODE.get().booleanValue() && wave.waveType() != null) {
            ArrayList missingWaveItems = new ArrayList();
            for (WaveItem<?> item : wave.waveType().items()) {
                if (wave.contains(item)) continue;
                missingWaveItems.add(item);
            }
            if (!missingWaveItems.isEmpty()) {
                LOGGER.log(BROKEN_WAVE_SENT, wave.toString());
                StringBuilder sb = new StringBuilder();
                for (WaveItem waveItem : missingWaveItems) {
                    sb.append(waveItem.toString());
                }
                LOGGER.log(BROKEN_WAVE_BAD_ITEM_LIST, sb.toString());
                throw new CoreRuntimeException(BROKEN_WAVE_BAD_ITEM_LIST.getText(sb.toString()));
            }
        }
    }
}

