/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.wave;

import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.api.wave.WaveListener;
import org.jrebirth.af.core.log.JRLoggerFactory;
import org.jrebirth.af.core.wave.WaveMessages;

public final class RelatedWaveListener
implements WaveListener,
WaveMessages {
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(RelatedWaveListener.class);

    @Override
    public void waveCreated(Wave wave) {
    }

    @Override
    public void waveSent(Wave wave) {
    }

    @Override
    public void waveProcessed(Wave wave) {
    }

    @Override
    public void waveCancelled(Wave wave) {
    }

    @Override
    public void waveConsumed(Wave wave) {
    }

    @Override
    public void waveHandled(Wave wave) {
        if (wave.relatedWave() != null) {
            LOGGER.trace(RELATED_WAVE_HANDLES, wave.fromClass().getSimpleName(), wave.relatedWave().toString());
            wave.relatedWave().status(Wave.Status.Handled);
        }
    }

    @Override
    public void waveFailed(Wave wave) {
        if (wave.relatedWave() != null) {
            LOGGER.log(RELATED_WAVE_HAS_FAILED, wave.componentClass().getSimpleName(), wave.relatedWave().toString());
            wave.relatedWave().status(Wave.Status.Failed);
        }
    }

    @Override
    public void waveDestroyed(Wave wave) {
    }
}

