/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.wave;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ObservableList;
import org.jrebirth.af.api.annotation.PriorityLevel;
import org.jrebirth.af.api.command.Command;
import org.jrebirth.af.api.service.Service;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.api.wave.WaveBean;
import org.jrebirth.af.api.wave.WaveGroup;
import org.jrebirth.af.api.wave.contract.WaveData;
import org.jrebirth.af.api.wave.contract.WaveItem;
import org.jrebirth.af.api.wave.contract.WaveType;
import org.jrebirth.af.core.command.basic.ChainWaveCommand;
import org.jrebirth.af.core.wave.JRebirthItems;
import org.jrebirth.af.core.wave.JRebirthWaves;
import org.jrebirth.af.core.wave.WaveBase;
import org.jrebirth.af.core.wave.WaveDataBase;
import org.jrebirth.af.core.wave.WaveTypeBase;

public interface WBuilder {
    public static WaveType waveType() {
        return new WaveTypeBase();
    }

    public static WaveType waveType(String action) {
        return WBuilder.waveType().action(action);
    }

    public static WaveType waveTypeDo(String action) {
        return WBuilder.waveType().action(action).prefix("DO_");
    }

    public static Wave wave() {
        return new WaveBase();
    }

    public static Wave callCommand(Class<? extends Command> commandClass) {
        return WBuilder.wave().waveGroup(WaveGroup.CALL_COMMAND).componentClass(commandClass);
    }

    public static Wave returnData(Class<? extends Service> serviceClass) {
        return WBuilder.wave().waveGroup(WaveGroup.RETURN_DATA).componentClass(serviceClass);
    }

    public static List<WaveData<?>> buildUiData(Object ... datas) {
        ArrayList wdList = new ArrayList();
        ArrayList<WaveBean> wbList = null;
        for (Object data : datas) {
            if (data instanceof ObjectProperty) {
                wdList.add(WBuilder.waveData(JRebirthWaves.ATTACH_UI_NODE_PLACEHOLDER, (ObjectProperty)data));
            }
            if (data instanceof ObservableList) {
                wdList.add(WBuilder.waveData(JRebirthWaves.ADD_UI_CHILDREN_PLACEHOLDER, (ObservableList)data));
            }
            if (data instanceof Class && Command.class.isAssignableFrom((Class)data)) {
                wdList.add(WBuilder.waveData(JRebirthWaves.SHOW_MODEL_COMMAND, (Class)data));
            }
            if (data instanceof List) {
                wdList.add(WBuilder.waveData(JRebirthWaves.KEY_PARTS, (List)data));
            }
            if (!(data instanceof WaveBean)) continue;
            if (wbList == null) {
                wbList = new ArrayList<WaveBean>();
                wdList.add(WBuilder.waveData(JRebirthWaves.EXTRA_WAVE_BEANS, wbList));
            }
            wbList.add((WaveBean)data);
        }
        return wdList;
    }

    public static <T> WaveData<T> waveData(WaveItem<T> waveItem, T value) {
        return new WaveDataBase<T>(waveItem, value);
    }

    public static Wave chainWaveCommand(List<Wave> waveList) {
        return WBuilder.wave().waveGroup(WaveGroup.CALL_COMMAND).componentClass(ChainWaveCommand.class).addDatas(WBuilder.waveData(JRebirthWaves.CHAINED_WAVES, waveList));
    }

    public static WaveData<PriorityLevel> priority(PriorityLevel level) {
        return WBuilder.waveData(JRebirthItems.priority, level);
    }

    public static WaveData<Long> timeout(long timeout) {
        return WBuilder.waveData(JRebirthItems.syncTimeout, timeout);
    }

    public static WaveData<Boolean> sync(boolean sync) {
        return WBuilder.waveData(JRebirthItems.runSynchronously, sync);
    }
}

