/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.wave;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.jrebirth.af.api.exception.CoreRuntimeException;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.api.wave.WaveBean;
import org.jrebirth.af.api.wave.WaveGroup;
import org.jrebirth.af.api.wave.WaveHandler;
import org.jrebirth.af.api.wave.WaveListener;
import org.jrebirth.af.api.wave.contract.WaveData;
import org.jrebirth.af.api.wave.contract.WaveItem;
import org.jrebirth.af.api.wave.contract.WaveType;
import org.jrebirth.af.core.link.LinkMessages;
import org.jrebirth.af.core.log.JRLoggerFactory;
import org.jrebirth.af.core.wave.WBuilder;

public class WaveBase
implements Wave,
LinkMessages {
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(WaveBase.class);
    private static final String SPACE_SEP = " ";
    private final String wuid;
    private final long timestamp;
    private final ObjectProperty<Wave.Status> statusProperty = new SimpleObjectProperty((Object)Wave.Status.Created);
    private WaveGroup waveGroup = WaveGroup.UNDEFINED;
    private WaveType waveType;
    private Class<?> fromClass;
    private Class<?> componentClass;
    private int priority;
    private Wave relatedWave;
    private boolean isRelated;
    private final Map<WaveItem<?>, WaveData<?>> waveItemsMap = new HashMap();
    private final List<WaveData<?>> waveDataList = new ArrayList();
    private Map<Class<? extends WaveBean>, WaveBean> waveBeanMap;
    private final List<WaveListener> waveListeners = Collections.synchronizedList(new ArrayList());
    private List<WaveHandler> waveHandlers;

    WaveBase() {
        this.wuid = UUID.randomUUID().toString();
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public WaveGroup waveGroup() {
        return this.waveGroup;
    }

    @Override
    public Wave waveGroup(WaveGroup waveGroup) {
        this.waveGroup = waveGroup;
        return this;
    }

    @Override
    public WaveType waveType() {
        return this.waveType;
    }

    @Override
    public Wave waveType(WaveType waveType) {
        this.waveType = waveType;
        return this;
    }

    @Override
    public Class<?> fromClass() {
        return this.fromClass;
    }

    @Override
    public Wave fromClass(Class<?> fromClass) {
        this.fromClass = fromClass;
        return this;
    }

    @Override
    public Class<?> componentClass() {
        return this.componentClass;
    }

    @Override
    public Wave componentClass(Class<?> componentClass) {
        this.componentClass = componentClass;
        return this;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    @Override
    public Wave priority(int priority) {
        this.priority = priority;
        return this;
    }

    @Override
    public Wave relatedWave() {
        return this.relatedWave;
    }

    @Override
    public Wave relatedWave(Wave relatedWave) {
        this.relatedWave = relatedWave;
        this.relatedWave.isRelated(true);
        return this;
    }

    @Override
    public boolean isRelated() {
        return this.isRelated;
    }

    @Override
    public Wave isRelated(boolean isRelated) {
        this.isRelated = isRelated;
        return this;
    }

    @Override
    public List<WaveData<?>> waveDatas() {
        return this.waveDataList;
    }

    @Override
    public Wave addDatas(WaveData<?> ... waveDatas) {
        for (WaveData<?> waveData : waveDatas) {
            waveData.order(this.waveDatas().size());
            WaveData<?> previous = this.waveItemsMap.get(waveData.key());
            this.waveItemsMap.put(waveData.key(), waveData);
            if (previous != null) {
                this.waveDataList.remove(previous);
            }
            this.waveDataList.add(waveData);
            Collections.sort(this.waveDataList);
        }
        return this;
    }

    @Override
    public <T> Wave add(WaveItem<T> waveItem, T value) {
        WaveData<T> waveData = WBuilder.waveData(waveItem, value);
        this.addDatas(waveData);
        return this;
    }

    @Override
    public <T> WaveData<T> getData(WaveItem<T> waveItem) {
        return this.waveItemsMap.get(waveItem);
    }

    @Override
    public <T> T get(WaveItem<T> waveItem) {
        return this.waveItemsMap.containsKey(waveItem) ? (T)this.waveItemsMap.get(waveItem).value() : null;
    }

    @Override
    public boolean contains(WaveItem<?> waveItem) {
        return this.waveItemsMap.containsKey(waveItem);
    }

    @Override
    public boolean containsNotNull(WaveItem<?> waveItem) {
        return this.contains(waveItem) && this.getData(waveItem).value() != null;
    }

    @Override
    public String wUID() {
        return this.wuid;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public Wave waveBean(WaveBean waveBean) {
        this.getWaveBeanMap().put(waveBean.getClass(), waveBean);
        return this;
    }

    private Map<Class<? extends WaveBean>, WaveBean> getWaveBeanMap() {
        if (this.waveBeanMap == null) {
            this.waveBeanMap = new HashMap<Class<? extends WaveBean>, WaveBean>();
        }
        return this.waveBeanMap;
    }

    @Override
    public <WB extends WaveBean> WB waveBean(Class<WB> waveBeanClass) {
        if (!this.getWaveBeanMap().containsKey(waveBeanClass)) {
            try {
                WaveBean waveBean = (WaveBean)waveBeanClass.newInstance();
                this.getWaveBeanMap().put(waveBeanClass, waveBean);
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOGGER.error(WAVE_BEAN_CREATION_ERROR, e, waveBeanClass.toString());
            }
        }
        return (WB)this.getWaveBeanMap().get(waveBeanClass);
    }

    @Override
    public List<WaveBean> waveBeanList() {
        if (this.waveBeanMap != null && !this.waveBeanMap.isEmpty()) {
            return new ArrayList<WaveBean>(this.waveBeanMap.values());
        }
        return new ArrayList<WaveBean>();
    }

    @Override
    public Wave waveBeanList(List<WaveBean> waveBeanList) {
        if (waveBeanList != null && !waveBeanList.isEmpty()) {
            waveBeanList.forEach(wb -> this.getWaveBeanMap().put((Class<? extends WaveBean>)wb.getClass(), (WaveBean)wb));
        }
        return this;
    }

    @Override
    public Wave addWaveListener(WaveListener waveListener) {
        this.waveListeners.add(waveListener);
        return this;
    }

    @Override
    public Wave removeWaveListener(WaveListener waveListener) {
        this.waveListeners.remove(waveListener);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Wave.Status status() {
        WaveBase waveBase = this;
        synchronized (waveBase) {
            return (Wave.Status)((Object)this.statusProperty.get());
        }
    }

    @Override
    public ObjectProperty<Wave.Status> statusProperty() {
        return this.statusProperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Wave status(Wave.Status status) {
        WaveBase waveBase = this;
        synchronized (waveBase) {
            if (this.statusProperty.get() == status) {
                throw new CoreRuntimeException("The status " + status.toString() + " has been already set for this wave " + this.toString());
            }
            this.statusProperty.set((Object)status);
            this.fireStatusChanged();
        }
        return this;
    }

    private void fireStatusChanged() {
        for (WaveListener waveListener : this.waveListeners) {
            switch ((Wave.Status)((Object)this.statusProperty.get())) {
                case Created: {
                    waveListener.waveCreated(this);
                    break;
                }
                case Sent: {
                    waveListener.waveSent(this);
                    break;
                }
                case Processing: {
                    waveListener.waveProcessed(this);
                    break;
                }
                case Consumed: {
                    waveListener.waveConsumed(this);
                    break;
                }
                case Handled: {
                    waveListener.waveHandled(this);
                    break;
                }
                case Failed: {
                    waveListener.waveFailed(this);
                    break;
                }
                case Cancelled: {
                    waveListener.waveCancelled(this);
                    break;
                }
                case Destroyed: {
                    waveListener.waveDestroyed(this);
                    break;
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.waveGroup() != null) {
            sb.append((Object)this.waveGroup()).append(SPACE_SEP);
        }
        if (this.fromClass() != null) {
            sb.append("fromClass=").append(this.fromClass().getSimpleName()).append(SPACE_SEP);
        }
        if (this.componentClass() != null) {
            sb.append("relatedClass=").append(this.componentClass().getSimpleName()).append(SPACE_SEP);
        }
        if (this.waveType() != null) {
            sb.append(this.waveType()).append(SPACE_SEP);
        }
        if (this.wUID() != null) {
            sb.append("(").append(this.wUID()).append(") ");
        }
        if (this.waveDatas().size() > 0) {
            sb.append("\r\nData=>");
            for (WaveData<?> wd : this.waveDatas()) {
                sb.append(wd.key()).append("=").append(wd.value());
            }
        }
        return sb.toString();
    }

    @Override
    public void setWaveHandlers(List<WaveHandler> waveHandlers) {
        this.waveHandlers = waveHandlers;
    }

    @Override
    public List<WaveHandler> getWaveHandlers() {
        return this.waveHandlers;
    }

    @Override
    public void removeWaveHandler(WaveHandler waveHandler) {
        if (waveHandler != null) {
            this.waveHandlers.remove(waveHandler);
            if (this.status() == Wave.Status.Consumed && this.waveHandlers.isEmpty() && !this.isRelated()) {
                LOGGER.info(NOTIFIER_HANDLES, this.toString());
                this.status(Wave.Status.Handled);
            }
        }
    }

    @Override
    public boolean hasWaveBean(Class<? extends WaveBean> waveBeanClass) {
        if (this.waveBeanMap != null && !this.waveBeanMap.isEmpty()) {
            return this.waveBeanMap.containsKey(waveBeanClass);
        }
        return false;
    }
}

