/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.wave;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jrebirth.af.api.command.Command;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.api.wave.contract.WaveItem;
import org.jrebirth.af.api.wave.contract.WaveType;
import org.jrebirth.af.core.resource.provided.parameter.CoreParameters;
import org.jrebirth.af.core.util.ObjectUtility;
import org.jrebirth.af.core.wave.WBuilder;
import org.jrebirth.af.core.wave.WaveTypeRegistry;

public final class WaveTypeBase
implements WaveType {
    private int uid;
    private String action;
    private String prefix;
    private final List<WaveItem<?>> waveItemList = new ArrayList();
    private String returnAction;
    private WaveItem<?> returnItem;
    private WaveType returnWaveType;
    private Class<? extends Command> returnCommandClass;
    private Map<Class<? extends Throwable>, Wave> waveExceptionHandler;

    WaveTypeBase() {
        this.uid(WaveTypeRegistry.getNextUid());
    }

    @Override
    public int uid() {
        return this.uid;
    }

    @Override
    public WaveTypeBase uid(int uid) {
        this.uid = uid;
        return this;
    }

    @Override
    public String action() {
        return this.action;
    }

    @Override
    public WaveTypeBase action(String action) {
        WaveTypeRegistry.store(action, this);
        this.action = action;
        return this;
    }

    @Override
    public String prefix() {
        return this.prefix == null ? CoreParameters.WAVE_HANDLER_PREFIX.get() : this.prefix;
    }

    @Override
    public WaveType prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public List<WaveItem<?>> items() {
        return this.waveItemList;
    }

    @Override
    public WaveTypeBase items(WaveItem<?> ... items) {
        for (WaveItem<?> waveItem : items) {
            this.waveItemList.add(waveItem);
        }
        return this;
    }

    @Override
    public String returnAction() {
        return this.returnAction;
    }

    @Override
    public WaveTypeBase returnAction(String returnAction) {
        this.returnAction = returnAction;
        this.buildReturnWaveType();
        return this;
    }

    @Override
    public WaveItem<?> returnItem() {
        return this.returnItem;
    }

    @Override
    public WaveTypeBase returnItem(WaveItem<?> returnItem) {
        this.returnItem = returnItem;
        this.buildReturnWaveType();
        return this;
    }

    private void buildReturnWaveType() {
        if (this.returnAction != null && this.returnItem != null) {
            this.returnWaveType(WBuilder.waveType(this.returnAction).items(this.returnItem()));
        }
    }

    @Override
    public WaveType returnWaveType() {
        return this.returnWaveType;
    }

    @Override
    public WaveType returnWaveType(WaveType returnWaveType) {
        WaveTypeRegistry.store(returnWaveType.action(), returnWaveType);
        this.returnWaveType = returnWaveType;
        this.returnAction = returnWaveType.action();
        this.returnItem = returnWaveType.items().stream().findFirst().orElse(null);
        return this;
    }

    public String getItems() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (WaveItem<?> waveItem : this.items()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            String fullName = waveItem.type() instanceof ParameterizedType ? ((ParameterizedType)waveItem.type()).toString() : ((Class)waveItem.type()).getName();
            sb.append(fullName).append(" ");
            fullName = fullName.replaceAll("[<>]", "");
            if (waveItem.name() == null || waveItem.name().isEmpty()) {
                sb.append(ObjectUtility.lowerFirstChar(fullName.substring(fullName.lastIndexOf(46) + 1)));
                continue;
            }
            sb.append(waveItem.name());
        }
        return sb.toString();
    }

    public String toString() {
        return this.prefix() + this.action;
    }

    public boolean equals(Object waveType) {
        return waveType instanceof WaveTypeBase && this.uid() == ((WaveTypeBase)waveType).uid();
    }

    public int hashCode() {
        return this.uid();
    }

    @Override
    public Class<? extends Command> returnCommandClass() {
        return this.returnCommandClass;
    }

    @Override
    public WaveType returnCommandClass(Class<? extends Command> returnCommandClass) {
        this.returnCommandClass = returnCommandClass;
        return this;
    }

    @Override
    public List<WaveItem<?>> parameters() {
        return this.items().stream().filter(item -> item.isParameter()).collect(Collectors.toList());
    }

    @Override
    public Map<Class<? extends Throwable>, Wave> waveExceptionHandler() {
        if (this.waveExceptionHandler == null) {
            this.waveExceptionHandler = new ConcurrentHashMap<Class<? extends Throwable>, Wave>();
        }
        return this.waveExceptionHandler;
    }

    @Override
    public WaveType onException(Class<? extends Command> exceptionCommandClass, Class<? extends Throwable> ... exceptionTypes) {
        Wave commandWave = WBuilder.callCommand(exceptionCommandClass);
        for (Class<? extends Throwable> type : exceptionTypes) {
            this.waveExceptionHandler().put(type, commandWave);
        }
        return this;
    }

    @Override
    public WaveType onException(WaveType exceptionWaveType, Class<? extends Throwable> ... exceptionTypes) {
        Wave wave = WBuilder.wave().waveType(exceptionWaveType);
        for (Class<? extends Throwable> type : exceptionTypes) {
            this.waveExceptionHandler().put(type, wave);
        }
        return this;
    }
}

