/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.wave;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jrebirth.af.api.wave.contract.WaveType;

public final class WaveTypeRegistry {
    public static final AtomicInteger idGenerator = new AtomicInteger();
    public static final Map<String, WaveType> waveTypeMap = Collections.synchronizedMap(new HashMap());

    private WaveTypeRegistry() {
    }

    public static int getNextUid() {
        return idGenerator.incrementAndGet();
    }

    public static WaveType getWaveType(String action) {
        WaveType waveType = null;
        if (waveTypeMap.containsKey(action)) {
            waveType = waveTypeMap.get(action);
        }
        return waveType;
    }

    public static void store(String action, WaveType waveType) {
        if (!waveTypeMap.containsKey(action)) {
            waveTypeMap.put(action, waveType);
        }
    }
}

