/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.processor;

import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jrebirth.af.api.annotation.bean.Bean;
import org.jrebirth.af.tooling.codegen.bean.Class;
import org.jrebirth.af.tooling.codegen.bean.Package;
import org.jrebirth.af.tooling.codegen.bean.Property;
import org.jrebirth.af.tooling.codegen.generator.Generators;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class BeanProcessor
extends AbstractProcessor {
    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return new HashSet<String>(Arrays.asList(Bean.class.getName()));
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ConcurrentHashMap fields = new ConcurrentHashMap();
        ConcurrentHashMap<String, ExecutableElement> methods = new ConcurrentHashMap<String, ExecutableElement>();
        for (Element element : roundEnv.getElementsAnnotatedWith(Bean.class)) {
            if (element.getKind() == ElementKind.CLASS) {
                Bean bean = element.getAnnotation(Bean.class);
                Class beanDef = new Class();
                TypeElement classElement = (TypeElement)element;
                PackageElement packageElement = (PackageElement)classElement.getEnclosingElement();
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "annotated class: " + classElement.getQualifiedName(), element);
                beanDef.name(bean.value());
                beanDef._package((Package)Package.create().qualifiedName(packageElement.getQualifiedName().toString()));
                Class td = new Class();
                td.qualifiedName(classElement.getQualifiedName().toString());
                beanDef.setSuperType(td);
                for (Element element2 : classElement.getEnclosedElements()) {
                    Property propertyDef;
                    if (element2.getKind() == ElementKind.METHOD) {
                        ExecutableElement method = (ExecutableElement)element2;
                        propertyDef = new Property();
                        propertyDef.type(Class.of(method.getReturnType().toString()));
                        propertyDef.name(method.getSimpleName().toString());
                        beanDef.properties().add(propertyDef);
                        continue;
                    }
                    if (!element2.getKind().isField()) continue;
                    VariableElement field = (VariableElement)element2;
                    propertyDef = new Property();
                    propertyDef.type(Class.of(this.getClassName(field)));
                    propertyDef.name(field.getSimpleName().toString());
                    beanDef.properties().add(propertyDef);
                }
                try {
                    String formattedSource = Generators.beanGenerator.generate(beanDef, Roaster.create(JavaClassSource.class));
                    JavaFileObject javaFileObject = this.processingEnv.getFiler().createSourceFile(beanDef.qualifiedName(), new Element[0]);
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "creating source file: " + javaFileObject.toUri());
                    Writer writer = javaFileObject.openWriter();
                    writer.write(formattedSource);
                    writer.close();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
            if (element.getKind() != ElementKind.METHOD) continue;
            ExecutableElement exeElement = (ExecutableElement)element;
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "annotated method: " + exeElement.getSimpleName(), element);
            methods.put(exeElement.getSimpleName().toString(), exeElement);
        }
        return true;
    }

    private String getClassName(Element element) {
        return this.getClassName(element.asType());
    }

    private String getClassName(TypeMirror t) {
        String res = null;
        if (t instanceof DeclaredType) {
            DeclaredType dt = (DeclaredType)t;
            res = ((TypeElement)dt.asElement()).getQualifiedName().toString();
            if (!dt.getTypeArguments().isEmpty()) {
                res = res + "<";
                boolean first = true;
                for (TypeMirror typeMirror : dt.getTypeArguments()) {
                    if (first) {
                        first = false;
                    } else {
                        res = res + ",";
                    }
                    res = res + this.getClassName(typeMirror);
                }
                res = res + ">";
            }
        } else if (t instanceof PrimitiveType) {
            res = ((PrimitiveType)t).toString();
        }
        return res;
    }

    private void error(Element source, String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, source);
    }
}

