/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.processor;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.forge.roaster.model.util.Formatter;
import org.jrebirth.af.api.annotation.Preload;
import org.jrebirth.af.api.annotation.PriorityLevel;
import org.jrebirth.af.api.module.BootComponent;
import org.jrebirth.af.api.module.Register;
import org.jrebirth.af.api.module.RegistrationPoint;
import org.jrebirth.af.core.module.AbstractModuleStarter;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class ComponentProcessor
extends AbstractProcessor {
    private static final String JREBIRTH_PROPERTIES_PATH = "jrebirth.properties";
    private static final String MODULE_STARTER_CLASS_PROPERTY = "moduleStarterClass";
    private static final String FORMATTER_PROPERTIES_FILE = "/org.eclipse.jdt.core.prefs";
    private static final String MODULE_STARTER_SPI_PATH = "META-INF/services/org.jrebirth.af.api.module.ModuleStarter";

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return new HashSet<String>(Arrays.asList(Preload.class.getName(), BootComponent.class.getName(), Register.class.getName(), RegistrationPoint.class.getName()));
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return false;
        }
        HashMap annotationMap = new HashMap();
        annotationMap.put(Preload.class, roundEnv.getElementsAnnotatedWith(Preload.class));
        annotationMap.put(BootComponent.class, roundEnv.getElementsAnnotatedWith(BootComponent.class));
        annotationMap.put(RegistrationPoint.class, roundEnv.getElementsAnnotatedWith(RegistrationPoint.class));
        annotationMap.put(Register.class, roundEnv.getElementsAnnotatedWith(Register.class));
        if (!(((Set)annotationMap.get(BootComponent.class)).isEmpty() && ((Set)annotationMap.get(RegistrationPoint.class)).isEmpty() && ((Set)annotationMap.get(Register.class)).isEmpty() && ((Set)annotationMap.get(Preload.class)).isEmpty())) {
            String moduleName = this.createModuleStarter(annotationMap, this.processingEnv);
            this.createSPIFile(moduleName);
        }
        return true;
    }

    private void createSPIFile(String moduleName) {
        try {
            FileObject fo = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", MODULE_STARTER_SPI_PATH, new Element[0]);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "creating spi file: " + fo.toUri());
            Writer writer = fo.openWriter();
            writer.write(moduleName);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private String createModuleStarter(Map<Class<?>, Set<? extends Element>> annotationMap, ProcessingEnvironment processingEnv) {
        String moduleName;
        try {
            moduleName = this.getModuleStarterName(processingEnv);
            String starterName = moduleName.substring(moduleName.lastIndexOf(46) + 1);
            String pkg = moduleName.substring(0, moduleName.lastIndexOf(46));
            JavaClassSource javaClass = Roaster.create(JavaClassSource.class);
            ((JavaClassSource)javaClass.setPackage(pkg)).setName(starterName);
            javaClass.extendSuperType(AbstractModuleStarter.class);
            StringBuilder body = new StringBuilder();
            this.appendRegistrationPoints(javaClass, body, annotationMap.get(RegistrationPoint.class));
            this.appendRegistrations(javaClass, body, annotationMap.get(Register.class));
            this.appendPreload(javaClass, body, annotationMap.get(Preload.class));
            this.appendBootComponent(javaClass, body, annotationMap.get(BootComponent.class));
            if (!javaClass.hasMethodSignature("start")) {
                MethodSource method = ((MethodSource)((MethodSource)javaClass.addMethod().setName("start")).setPublic()).setBody(body.toString()).setReturnTypeVoid();
                method.getJavaDoc().setFullText("{@inheritDoc}");
                method.addAnnotation(Override.class);
            } else {
                javaClass.getMethod("start").setBody(javaClass.getMethod("start").getBody() + body.toString());
            }
            Properties prefs = new Properties();
            prefs.load(this.getClass().getResourceAsStream(FORMATTER_PROPERTIES_FILE));
            String formattedSource = Formatter.format(prefs, javaClass);
            JavaFileObject jfo = this.processingEnv.getFiler().createSourceFile(moduleName, new Element[0]);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "creating source file: " + jfo.toUri());
            Writer writer = jfo.openWriter();
            writer.write(formattedSource);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return moduleName;
    }

    private void appendPreload(JavaClassSource javaClass, StringBuilder body, Set<? extends Element> list) {
        for (Element element : list) {
            body.append("\npreloadClass(").append(this.getSimpleClassName(element)).append(".class);\n");
            javaClass.addImport(this.getClassName(element));
        }
    }

    private void appendBootComponent(JavaClassSource javaClass, StringBuilder body, Set<? extends Element> list) {
        for (Element element : list) {
            body.append("\nbootComponent(").append(this.getSimpleClassName(element)).append(".class);\n");
            javaClass.addImport(this.getClassName(element));
        }
    }

    private void appendRegistrations(JavaClassSource javaClass, StringBuilder body, Set<? extends Element> list) {
        for (Element element : list) {
            Register r = element.getAnnotation(Register.class);
            TypeMirror value = null;
            try {
                r.value();
            }
            catch (MirroredTypeException mte) {
                value = mte.getTypeMirror();
            }
            body.append("\nregister(").append(this.getSimpleClassName(value)).append(".class, ").append(this.getSimpleClassName(element)).append(".class, ").append("PriorityLevel.").append(r.priority().name()).append(", ").append(r.weight()).append(");\n");
            javaClass.addImport(this.getClassName(value));
            javaClass.addImport(this.getClassName(element));
            javaClass.addImport(PriorityLevel.class);
        }
    }

    private void appendRegistrationPoints(JavaClassSource javaClass, StringBuilder body, Set<? extends Element> list) {
        for (Element element : list) {
            RegistrationPoint r = element.getAnnotation(RegistrationPoint.class);
            body.append("\ndefine(").append(this.getSimpleClassName(element)).append(".class, ").append(Boolean.toString(r.exclusive())).append(", ").append(Boolean.toString(r.reverse())).append(");\n");
            javaClass.addImport(this.getClassName(element));
        }
    }

    private String getClassName(Element element) {
        return this.getClassName(element.asType());
    }

    private String getClassName(TypeMirror t) {
        String res = null;
        if (t instanceof DeclaredType) {
            DeclaredType dt = (DeclaredType)t;
            res = ((TypeElement)dt.asElement()).getQualifiedName().toString();
        }
        return res;
    }

    private String getSimpleClassName(Element element) {
        return this.getSimpleClassName(element.asType());
    }

    private String getSimpleClassName(TypeMirror t) {
        String res = null;
        if (t instanceof DeclaredType) {
            DeclaredType dt = (DeclaredType)t;
            res = dt.asElement().getSimpleName().toString();
        }
        return res;
    }

    private String getModuleStarterName(ProcessingEnvironment processingEnv) throws IOException, XmlPullParserException, NoSuchFieldException, IllegalAccessException {
        String name = null;
        try {
            FileObject resource = processingEnv.getFiler().getResource(StandardLocation.CLASS_PATH, "", JREBIRTH_PROPERTIES_PATH);
            InputStream propertiesStream = resource.openInputStream();
            Properties properties = new Properties();
            properties.load(propertiesStream);
            name = properties.getProperty(MODULE_STARTER_CLASS_PROPERTY);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (name == null || name.isEmpty()) {
            name = this.getModuleStarterNameFromMaven(processingEnv);
        }
        return name;
    }

    private String getProjectPath() {
        try {
            JavaFileObject generationForPath = this.processingEnv.getFiler().createSourceFile("PathFinder", new Element[0]);
            Writer writer = generationForPath.openWriter();
            String sourcePath = generationForPath.toUri().getPath();
            writer.close();
            return sourcePath.substring(0, sourcePath.indexOf("/target"));
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Unable to determine source file path!");
            return "";
        }
    }

    private String getModuleStarterNameFromMaven(ProcessingEnvironment processingEnv) throws IOException, NoSuchFieldException, IllegalAccessException, XmlPullParserException {
        String baseDir = this.getProjectPath() + "/";
        MavenXpp3Reader pomReader = new MavenXpp3Reader();
        Model model = pomReader.read(new FileReader(new File(baseDir + "pom.xml")));
        String pkg = model.getGroupId() + "." + model.getArtifactId();
        String starterName = StringUtils.capitalize(model.getArtifactId()) + "ModuleStarter";
        return pkg + "." + starterName;
    }
}

