/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.tooling.codegen.bean;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jrebirth.af.tooling.codegen.bean.Operation;
import org.jrebirth.af.tooling.codegen.bean.Packageable;
import org.jrebirth.af.tooling.codegen.bean.Property;
import org.jrebirth.af.tooling.codegen.bean.TypeVariable;

public class Class
extends Packageable<Class> {
    private boolean isInterface = false;
    private boolean isAbstract = false;
    private Class superType;
    private List<Class> implementedTypes = new ArrayList<Class>();
    private List<Property> properties = new ArrayList<Property>();
    private List<Operation> operations = new ArrayList<Operation>();
    private List<TypeVariable> typeVariables = new ArrayList<TypeVariable>();

    public static Class of(String qualifiedName) {
        return (Class)new Class().qualifiedName(qualifiedName);
    }

    public Class getSuperType() {
        return this.superType;
    }

    public Class setSuperType(Class superType) {
        this.superType = superType;
        return this;
    }

    public List<Operation> operations() {
        return this.operations;
    }

    public Class operations(List<Operation> operations) {
        this.operations = operations;
        return this;
    }

    public Class addOperation(Operation operations) {
        this.operations.addAll(Arrays.asList(operations));
        return this;
    }

    public Class removeOperation(Operation ... operations) {
        this.operations.removeAll(Arrays.asList(operations));
        return this;
    }

    public List<TypeVariable> typeVariables() {
        return this.typeVariables;
    }

    public Class typeVariables(List<TypeVariable> typeVariables) {
        this.typeVariables = typeVariables;
        return this;
    }

    public Class addTypeVariable(TypeVariable typeVariables) {
        this.typeVariables.addAll(Arrays.asList(typeVariables));
        return this;
    }

    public Class removeTypeVariable(TypeVariable ... typeVariables) {
        this.typeVariables.removeAll(Arrays.asList(typeVariables));
        return this;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public Class isInterface(boolean isInterface) {
        this.isInterface = isInterface;
        return this;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public Class isAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
        return this;
    }

    public List<Class> implementedTypes() {
        return this.implementedTypes;
    }

    public Class implementedTypes(List<Class> implementedTypes) {
        this.implementedTypes = implementedTypes;
        return this;
    }

    public Class addImplementedType(Class implementedTypes) {
        this.implementedTypes.addAll(Arrays.asList(implementedTypes));
        return this;
    }

    public Class removeImplementedType(Class ... implementedTypes) {
        this.implementedTypes.removeAll(Arrays.asList(implementedTypes));
        return this;
    }

    public List<Property> properties() {
        return this.properties;
    }

    public Class properties(List<Property> properties) {
        this.properties = properties;
        this.properties.stream().forEach(p -> p.owner(this));
        return this;
    }

    public Class addProperty(Property ... properties) {
        this.properties.addAll(Arrays.asList(properties));
        this.properties.stream().forEach(p -> p.owner(this));
        return this;
    }

    public Class removeProperty(Property ... properties) {
        this.properties.removeAll(Arrays.asList(properties));
        this.properties.stream().forEach(p -> p.owner(null));
        return this;
    }

    public String getFluentType() {
        String res = "";
        if (!this.typeVariables().isEmpty() && !this.getName().equals(this.typeVariables().get(0).getName())) {
            res = "(" + this.typeVariables().get(0).getName() + ") ";
        }
        return res;
    }

    public String qualifiedNameWithParameter() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.qualifiedName());
        if (!this.typeVariables().isEmpty()) {
            sb.append("<");
            boolean first = true;
            for (TypeVariable tv : this.typeVariables()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(tv.getName());
            }
            sb.append(">");
        }
        return sb.toString();
    }
}

