/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.tooling.codegen.bean;

import org.jrebirth.af.tooling.codegen.bean.Class;
import org.jrebirth.af.tooling.codegen.bean.Packageable;
import org.jrebirth.af.tooling.codegen.bean.TypedDefinition;

public class Property
extends TypedDefinition<Property> {
    private Packageable<?> owner;
    private boolean requireField = true;
    private boolean needProperty = true;
    private boolean needGetter = true;
    private boolean needSetter = true;
    private boolean needAddList = true;
    private boolean needRemoveList = true;
    private boolean needPutMap = true;
    private boolean needRemoveMap = true;

    public static Property of(String name) {
        return (Property)new Property().name(name);
    }

    public Packageable<?> owner() {
        return this.owner;
    }

    public Property owner(Packageable<?> owner) {
        this.owner = owner;
        return this;
    }

    public boolean requireField() {
        return this.requireField;
    }

    public Property requireField(boolean requireField) {
        this.requireField = requireField;
        return this;
    }

    public boolean needProperty() {
        return this.needProperty;
    }

    public Property needProperty(boolean needProperty) {
        this.needProperty = needProperty;
        return this;
    }

    public boolean needGetter() {
        return this.needGetter;
    }

    public Property needGetter(boolean needGetter) {
        this.needGetter = needGetter;
        return this;
    }

    public boolean needSetter() {
        return this.needSetter;
    }

    public Property needSetter(boolean needSetter) {
        this.needSetter = needSetter;
        return this;
    }

    public void needAddList(boolean needAddList) {
        this.needAddList = needAddList;
    }

    public boolean needAddList() {
        return this.needAddList;
    }

    public void needRemoveList(boolean needRemoveList) {
        this.needRemoveList = needRemoveList;
    }

    public boolean needRemoveList() {
        return this.needRemoveList;
    }

    public void needPutMap(boolean needPutMap) {
        this.needPutMap = needPutMap;
    }

    public boolean needPutMap() {
        return this.needPutMap;
    }

    public void needRemoveMap(boolean needRemoveMap) {
        this.needRemoveMap = needRemoveMap;
    }

    public boolean needRemoveMap() {
        return this.needRemoveMap;
    }

    public String getPropertyName() {
        return "p" + this.getUpperName();
    }

    public String getUpperName() {
        return this.name().substring(0, 1).toUpperCase() + this.name().substring(1);
    }

    public String getPropertyType() {
        if (this.type().qualifiedName().startsWith("java.util.List")) {
            return this.type().qualifiedName().replace("java.util.List", "javafx.collections.ObservableList");
        }
        if (this.type().qualifiedName().startsWith("java.util.Map")) {
            return this.type().qualifiedName().replace("java.util.Map", "javafx.collections.ObservableMap");
        }
        switch (this.type().qualifiedName()) {
            case "boolean": {
                return "javafx.beans.property.BooleanProperty";
            }
            case "int": {
                return "javafx.beans.property.IntegerProperty";
            }
            case "long": {
                return "javafx.beans.property.LongProperty";
            }
            case "float": {
                return "javafx.beans.property.FloatProperty";
            }
            case "double": {
                return "javafx.beans.property.DoubleProperty";
            }
            case "string": {
                return "javafx.beans.property.StringProperty";
            }
        }
        return "javafx.beans.property.ObjectProperty<" + this.type() + ">";
    }

    public String getConcretePropertyType() {
        if (this.type().qualifiedName().startsWith("java.util.List")) {
            return "FXCollections.observableList";
        }
        if (this.type().qualifiedName().startsWith("java.util.Map")) {
            return "FXCollections.observableMap";
        }
        switch (this.type().qualifiedName()) {
            case "boolean": {
                return "javafx.beans.property.SimpleBooleanProperty";
            }
            case "int": {
                return "javafx.beans.property.SimpleIntegerProperty";
            }
            case "long": {
                return "javafx.beans.property.SimpleLongProperty";
            }
            case "float": {
                return "javafx.beans.property.SimpleFloatProperty";
            }
            case "double": {
                return "javafx.beans.property.SimpleDoubleProperty";
            }
            case "string": {
                return "javafx.beans.property.SimpleStringProperty";
            }
        }
        return "javafx.beans.property.SimpleObjectProperty<" + this.type().qualifiedName() + ">";
    }

    public boolean isList() {
        return this.getConcretePropertyType().contains("observableList");
    }

    public boolean isMap() {
        return this.getConcretePropertyType().contains("observableMap");
    }

    public String subtype() {
        String type = this.type().qualifiedName();
        return type.substring(type.indexOf("<") + 1, type.lastIndexOf(">"));
    }

    public String getFluentType() {
        if (this.owner instanceof Class) {
            return ((Class)this.owner).getFluentType();
        }
        return "";
    }
}

