/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.tooling.codegen.generator;

import java.io.IOException;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jboss.forge.roaster.model.JavaClass;
import org.jboss.forge.roaster.model.JavaInterface;
import org.jboss.forge.roaster.model.source.FieldHolderSource;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.GenericCapableSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodHolderSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.forge.roaster.model.util.Formatter;
import org.jrebirth.af.tooling.codegen.bean.Class;
import org.jrebirth.af.tooling.codegen.bean.Operation;
import org.jrebirth.af.tooling.codegen.bean.Property;
import org.jrebirth.af.tooling.codegen.generator.BeanGenerator;
import org.jrebirth.af.tooling.codegen.generator.CodeGenerator;
import org.jrebirth.af.tooling.codegen.template.TemplateName;
import org.jrebirth.af.tooling.codegen.template.Templates;

public abstract class AbstractGenerator<B, J>
implements CodeGenerator<B, J> {
    protected String formatClass(JavaClassSource javaClass) {
        Properties prefs = new Properties();
        try {
            prefs.load(BeanGenerator.class.getResourceAsStream("/org.eclipse.jdt.core.prefs"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String formattedSource = prefs != null ? Formatter.format(prefs, javaClass) : Formatter.format(javaClass);
        return formattedSource;
    }

    protected void writeOperation(MethodHolderSource<?> methodHolder, Operation o) {
        if (!methodHolder.hasMethodSignature(o.name(), o.parameters().stream().map(p -> p.getName()).collect(Collectors.toList()).toArray(new String[0]))) {
            StringBuilder javadoc = new StringBuilder();
            javadoc.append(".");
            String body = Templates.use(TemplateName.Operation, o);
            MethodSource method = ((MethodSource)((MethodSource)((MethodSource)methodHolder.addMethod().setName(o.name())).setAbstract(o.isAbstract())).setStatic(o.isStatic())).setDefault(o.isDefault());
            if (o.returnType() != null) {
                method.setReturnType(o.returnType().qualifiedName());
            } else {
                method.setReturnTypeVoid();
            }
            if (methodHolder instanceof JavaInterface && o.isDefault() || methodHolder instanceof JavaClass && !o.isAbstract()) {
                method.setBody(body);
            } else {
                method.setBody(null);
            }
            switch (o.visibility()) {
                case _package: {
                    method.setPackagePrivate();
                    break;
                }
                case _private: {
                    method.setPrivate();
                    break;
                }
                case _protected: {
                    method.setProtected();
                    break;
                }
                case _public: {
                    method.setPublic();
                    break;
                }
            }
            o.parameters().stream().forEach(td -> method.addParameter(td.type().qualifiedName(), td.name()));
        }
    }

    protected void writeField(FieldHolderSource<?> fieldHolder, Property propDef) {
        if (propDef.requireField() && !fieldHolder.hasField(propDef.name())) {
            StringBuilder javadoc = new StringBuilder();
            javadoc.append("The field ").append(propDef.name());
            FieldSource method = (FieldSource)((FieldSource)fieldHolder.addField().setType(propDef.type().qualifiedName()).setName(propDef.name())).setPrivate();
            method.getJavaDoc().setFullText(javadoc.toString());
        }
    }

    protected void manageGenerics(Class cls, GenericCapableSource<?, ?> javaClass) {
        cls.typeVariables().stream().forEach(tv -> javaClass.addTypeVariable(tv.name()));
    }
}

