/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.tooling.codegen.generator;

import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.forge.roaster.model.source.TypeVariableSource;
import org.jrebirth.af.tooling.codegen.bean.Class;
import org.jrebirth.af.tooling.codegen.bean.Operation;
import org.jrebirth.af.tooling.codegen.bean.Property;
import org.jrebirth.af.tooling.codegen.generator.AbstractGenerator;
import org.jrebirth.af.tooling.codegen.template.TemplateName;
import org.jrebirth.af.tooling.codegen.template.Templates;

public class BeanGenerator
extends AbstractGenerator<Class, JavaClassSource> {
    BeanGenerator() {
    }

    @Override
    public String generate(Class cls, JavaClassSource javaClass) {
        ((JavaClassSource)javaClass.setPackage(cls._package().qualifiedName())).setName(cls.name());
        this.manageGenerics(cls, javaClass);
        if (cls.getSuperType() != null) {
            javaClass.setSuperType(cls.getSuperType().qualifiedNameWithParameter());
        }
        cls.implementedTypes().stream().forEach(i -> {
            JavaClassSource cfr_ignored_0 = (JavaClassSource)javaClass.addInterface(i.qualifiedNameWithParameter());
        });
        cls.properties().stream().forEach(propDef -> {
            this.writeField(javaClass, (Property)propDef);
            this.writeProperty(javaClass, (Property)propDef);
        });
        this.writeCreator(javaClass, cls);
        cls.properties().stream().forEach(p -> {
            this.writeGetter(javaClass, (Property)p);
            this.writeSetter(javaClass, (Property)p);
            this.writePropertyGetter(javaClass, (Property)p);
        });
        cls.properties().stream().filter(p -> p.isList()).forEach(p -> {
            this.writeListAdd(javaClass, (Property)p);
            this.writeListRemove(javaClass, (Property)p);
        });
        cls.properties().stream().filter(p -> p.isMap()).forEach(p -> {
            this.writeMapPut(javaClass, (Property)p);
            this.writeMapPut(javaClass, (Property)p);
        });
        cls.operations().stream().forEach(o -> this.writeOperation(javaClass, (Operation)o));
        return this.formatClass(javaClass);
    }

    private void writeCreator(JavaClassSource javaClass, Class beanDef) {
        if (!beanDef.isAbstract() && !javaClass.hasMethodSignature("create")) {
            StringBuilder javadoc = new StringBuilder();
            javadoc.append("Build a new instance of {@link ").append(beanDef.name()).append("}.");
            String body = Templates.use(TemplateName.Creator, beanDef);
            MethodSource method = ((MethodSource)((MethodSource)((MethodSource)javaClass.addMethod().setName("of")).setPublic()).setStatic(true)).setBody(body).setReturnType(beanDef.qualifiedName());
            method.getJavaDoc().setFullText(javadoc.toString()).addTagValue("@return", "a fresh instance");
        }
    }

    private void writeProperty(JavaClassSource javaClass, Property propDef) {
        if (!javaClass.hasField(propDef.getPropertyName())) {
            StringBuilder javadoc = new StringBuilder();
            javadoc.append("The property for ").append(propDef.name());
            FieldSource method = (FieldSource)((FieldSource)javaClass.addField().setType(propDef.getPropertyType()).setName(propDef.getPropertyName())).setPrivate();
            method.getJavaDoc().setFullText(javadoc.toString());
        }
    }

    private void writeGetter(JavaClassSource javaClass, Property propDef) {
        if (propDef.needGetter() && !javaClass.hasMethodSignature(propDef.name())) {
            StringBuilder javadoc = new StringBuilder();
            javadoc.append("@return the sourcePath\n");
            String body = "";
            if (propDef.isList()) {
                javaClass.addImport("java.util.stream.Collectors");
                javaClass.addImport("java.util.ArrayList");
                body = Templates.use(TemplateName.Getter_List, propDef);
            } else if (propDef.isMap()) {
                javaClass.addImport("java.util.stream.Collectors");
                javaClass.addImport("java.util.HashMap");
                body = Templates.use(TemplateName.Getter_Map, propDef);
            } else {
                body = Templates.use(TemplateName.Getter, propDef);
            }
            MethodSource method = ((MethodSource)((MethodSource)javaClass.addMethod().setName(propDef.name())).setPublic()).setBody(body).setReturnType(propDef.type().qualifiedName());
            method.getJavaDoc().setFullText(javadoc.toString());
        }
    }

    private void writeSetter(JavaClassSource javaClass, Property propDef) {
        if (propDef.needSetter()) {
            String body = "";
            body = propDef.isList() ? Templates.use(TemplateName.Setter_List, propDef) : (propDef.isMap() ? Templates.use(TemplateName.Setter_Map, propDef) : Templates.use(TemplateName.Setter, propDef));
            MethodSource method = ((MethodSource)((MethodSource)javaClass.addMethod().setName(propDef.name())).setPublic()).setBody(body).setReturnType(javaClass.getTypeVariables().isEmpty() ? javaClass.getName() : ((TypeVariableSource)javaClass.getTypeVariables().get(0)).getName());
            method.addParameter(propDef.type().qualifiedName(), propDef.name());
        }
    }

    private void writePropertyGetter(JavaClassSource javaClass, Property propDef) {
        if (propDef.needGetter() && propDef.needProperty() && !javaClass.hasMethodSignature(propDef.getPropertyName())) {
            StringBuilder javadoc = new StringBuilder();
            javadoc.append("@return the pSourcePath\n");
            String body = "";
            if (propDef.isList()) {
                javaClass.addImport("javafx.collections.FXCollections");
                body = Templates.use(TemplateName.PropertyGetter_List, propDef);
            } else if (propDef.isMap()) {
                javaClass.addImport("javafx.collections.FXCollections");
                body = Templates.use(TemplateName.PropertyGetter_Map, propDef);
            } else {
                body = Templates.use(TemplateName.PropertyGetter, propDef);
            }
            MethodSource method = ((MethodSource)((MethodSource)javaClass.addMethod().setName(propDef.getPropertyName())).setPublic()).setBody(body.toString()).setReturnType(propDef.getPropertyType());
            method.getJavaDoc().setFullText(javadoc.toString());
        }
    }

    private void writeListAdd(JavaClassSource javaClass, Property propDef) {
        String name = "add" + propDef.getUpperName();
        if (!javaClass.hasMethodSignature(name)) {
            StringBuilder javadoc = new StringBuilder();
            javadoc.append("@return the pSourcePath\n");
            String body = "";
            javaClass.addImport("javafx.collections.FXCollections");
            javaClass.addImport("java.util.Arrays");
            body = Templates.use(TemplateName.PropertyAddList, propDef);
            MethodSource method = ((MethodSource)((MethodSource)javaClass.addMethod().setName(name)).setPublic()).setBody(body.toString()).setReturnType(javaClass.getTypeVariables().isEmpty() ? javaClass.getName() : ((TypeVariableSource)javaClass.getTypeVariables().get(0)).getName());
            method.addParameter(propDef.subtype(), propDef.name()).setVarArgs(true);
            method.getJavaDoc().setFullText(javadoc.toString());
        }
    }

    private void writeListRemove(JavaClassSource javaClass, Property propDef) {
        String name = "remove" + propDef.getUpperName();
        if (!javaClass.hasMethodSignature(name)) {
            StringBuilder javadoc = new StringBuilder();
            javadoc.append("@return the pSourcePath\n");
            String body = "";
            javaClass.addImport("javafx.collections.FXCollections");
            javaClass.addImport("java.util.Arrays");
            body = Templates.use(TemplateName.PropertyRemoveList, propDef);
            MethodSource method = ((MethodSource)((MethodSource)javaClass.addMethod().setName(name)).setPublic()).setBody(body.toString()).setReturnType(javaClass.getTypeVariables().isEmpty() ? javaClass.getName() : ((TypeVariableSource)javaClass.getTypeVariables().get(0)).getName());
            method.addParameter(propDef.subtype(), propDef.name()).setVarArgs(true);
            method.getJavaDoc().setFullText(javadoc.toString());
        }
    }

    private void writeMapPut(JavaClassSource javaClass, Property propDef) {
        String name = "put" + propDef.getPropertyName();
        if (!javaClass.hasMethodSignature(name)) {
            StringBuilder javadoc = new StringBuilder();
            javadoc.append("@return the pSourcePath\n");
            String body = "";
            javaClass.addImport("javafx.collections.FXCollections");
            body = Templates.use(TemplateName.PropertyPutMap, propDef);
            MethodSource method = ((MethodSource)((MethodSource)javaClass.addMethod().setName(name)).setPublic()).setBody(body.toString()).setReturnType(javaClass.getTypeVariables().isEmpty() ? javaClass.getName() : ((TypeVariableSource)javaClass.getTypeVariables().get(0)).getName());
            method.getJavaDoc().setFullText(javadoc.toString());
        }
    }

    private void writeMapRemove(JavaClassSource javaClass, Property propDef) {
        String name = "remove" + propDef.getPropertyName();
        if (!javaClass.hasMethodSignature(name)) {
            StringBuilder javadoc = new StringBuilder();
            javadoc.append("@return the pSourcePath\n");
            String body = "";
            javaClass.addImport("javafx.collections.FXCollections");
            body = Templates.use(TemplateName.PropertyRemoveMap, propDef);
            MethodSource method = ((MethodSource)((MethodSource)javaClass.addMethod().setName(name)).setPublic()).setBody(body.toString()).setReturnType(javaClass.getTypeVariables().isEmpty() ? javaClass.getName() : ((TypeVariableSource)javaClass.getTypeVariables().get(0)).getName());
            method.getJavaDoc().setFullText(javadoc.toString());
        }
    }
}

