/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.sample.ui;

import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import org.jrebirth.af.core.exception.CoreException;
import org.jrebirth.af.core.ui.AbstractController;
import org.jrebirth.af.core.ui.View;
import org.jrebirth.af.core.ui.adapter.DefaultMouseAdapter;
import org.jrebirth.af.core.ui.adapter.EventAdapter;
import org.jrebirth.af.core.wave.Wave;
import org.jrebirth.af.core.wave.WaveBuilder;
import org.jrebirth.af.core.wave.WaveData;
import org.jrebirth.af.core.wave.WaveGroup;
import org.jrebirth.af.sample.command.SampleCommand;
import org.jrebirth.af.sample.command.SamplePoolCommand;
import org.jrebirth.af.sample.command.SampleUICommand;
import org.jrebirth.af.sample.ui.SampleModel;
import org.jrebirth.af.sample.ui.SampleView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SampleController
extends AbstractController<SampleModel, SampleView> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SampleController.class);

    public SampleController(SampleView view) throws CoreException {
        super((View)view);
    }

    protected void initEventAdapters() throws CoreException {
        this.linkCommand((Node)((SampleView)this.getView()).getUiCommand(), MouseEvent.MOUSE_CLICKED, SampleUICommand.class, new WaveData[0]);
        this.addAdapter((EventAdapter)new SampleMouseAdapter());
    }

    protected void initEventHandlers() throws CoreException {
        ((SampleView)this.getView()).getPooledCommand().setOnMouseClicked(this.getHandler(MouseEvent.MOUSE_CLICKED));
    }

    void onMouseClicked(MouseEvent event) {
        LOGGER.debug("MouseClicked => Call Sample Command");
        ((SampleCommand)((SampleModel)this.getModel()).getCommand(SampleCommand.class, new Object[0])).run();
    }

    private class SampleMouseAdapter
    extends DefaultMouseAdapter<SampleController> {
        private SampleMouseAdapter() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            super.mouseClicked(mouseEvent);
            LOGGER.debug("MouseClicked => Call Sample Pool Command");
            ((SampleModel)SampleController.this.getModel()).sendWave((Wave)WaveBuilder.create().waveGroup(WaveGroup.CALL_COMMAND).relatedClass(SamplePoolCommand.class).build());
        }
    }
}

