/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.sample.ui;

import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.LabelBuilder;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPaneBuilder;
import org.jrebirth.af.core.exception.CoreException;
import org.jrebirth.af.core.ui.AbstractView;
import org.jrebirth.af.core.ui.Model;
import org.jrebirth.af.core.ui.annotation.OnMouse;
import org.jrebirth.af.sample.ui.SampleController;
import org.jrebirth.af.sample.ui.SampleModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SampleView
extends AbstractView<SampleModel, BorderPane, SampleController> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SampleView.class);
    @OnMouse(value={OnMouse.MouseType.Clicked})
    private Button defaultCommand;
    private Button uiCommand;
    private Button pooledCommand;

    public SampleView(SampleModel model) throws CoreException {
        super((Model)model);
    }

    protected void initView() {
        this.defaultCommand = new Button("Trigger a default Command into JIT");
        this.uiCommand = new Button("Trigger an UI Command into JAT");
        this.pooledCommand = new Button("Trigger a pooled Command into JTP");
        ((BorderPane)this.getRootNode()).setCenter((Node)((LabelBuilder)LabelBuilder.create().text("JRebirth Sample")).build());
        ((BorderPane)this.getRootNode()).setBottom((Node)((FlowPaneBuilder)FlowPaneBuilder.create().children(new Node[]{this.defaultCommand, this.uiCommand, this.pooledCommand})).build());
    }

    public void start() {
        LOGGER.debug("Start the Sample View");
    }

    public void reload() {
        LOGGER.debug("Reload the Sample View");
    }

    public void hide() {
        LOGGER.debug("Hide the Sample View");
    }

    Button getDefaultCommand() {
        return this.defaultCommand;
    }

    Button getUiCommand() {
        return this.uiCommand;
    }

    Button getPooledCommand() {
        return this.pooledCommand;
    }
}

