/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.application;

import com.sun.javafx.application.LauncherImpl;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javafx.application.Application;
import javafx.application.Preloader;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.scene.SceneBuilder;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.util.Pair;
import org.jrebirth.af.api.application.Configuration;
import org.jrebirth.af.api.application.JRebirthApplication;
import org.jrebirth.af.api.application.Localized;
import org.jrebirth.af.api.command.Command;
import org.jrebirth.af.api.exception.CoreException;
import org.jrebirth.af.api.exception.JRebirthThreadException;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.api.resource.ResourceItem;
import org.jrebirth.af.api.resource.style.StyleSheetItem;
import org.jrebirth.af.api.service.Service;
import org.jrebirth.af.api.ui.Model;
import org.jrebirth.af.core.application.ApplicationMessages;
import org.jrebirth.af.core.concurrent.AbstractJrbRunnable;
import org.jrebirth.af.core.concurrent.JRebirth;
import org.jrebirth.af.core.concurrent.JRebirthThread;
import org.jrebirth.af.core.exception.handler.DefaultUncaughtExceptionHandler;
import org.jrebirth.af.core.exception.handler.JatUncaughtExceptionHandler;
import org.jrebirth.af.core.exception.handler.JitUncaughtExceptionHandler;
import org.jrebirth.af.core.exception.handler.PoolUncaughtExceptionHandler;
import org.jrebirth.af.core.log.JRLoggerFactory;
import org.jrebirth.af.core.resource.ResourceBuilders;
import org.jrebirth.af.core.resource.provided.JRebirthColors;
import org.jrebirth.af.core.resource.provided.JRebirthParameters;
import org.jrebirth.af.core.resource.provided.JRebirthStyles;
import org.jrebirth.af.core.util.ClassUtility;
import org.jrebirth.af.core.util.ClasspathUtility;
import org.jrebirth.af.modular.ModuleConfigFileParser;
import org.jrebirth.af.preloader.JRebirthPreloader;

@Configuration(value=".*jrebirth")
@Localized(value=".*_rb")
public abstract class AbstractApplication<P extends Pane>
extends Application
implements JRebirthApplication<P>,
ApplicationMessages {
    private static final String PARAM = "{}";
    private static final String APP_SUFFIX_CLASSNAME = "Application";
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(AbstractApplication.class);
    private transient Stage stage;
    private transient Scene scene;
    private transient P rootNode;

    protected static void preloadAndLaunch(String ... args) {
        AbstractApplication.preloadAndLaunch(ClassUtility.getClassFromStaticMethod(3), JRebirthPreloader.class, args);
    }

    protected static void preloadAndLaunch(Class<? extends Preloader> preloaderClass, String ... args) {
        AbstractApplication.preloadAndLaunch(ClassUtility.getClassFromStaticMethod(3), preloaderClass, args);
    }

    protected static void preloadAndLaunch(Class<? extends Application> appClass, Class<? extends Preloader> preloaderClass, String ... args) {
        LauncherImpl.launchApplication(appClass, preloaderClass, (String[])args);
    }

    protected static void launchNow(String ... args) {
        AbstractApplication.launchNow(ClassUtility.getClassFromStaticMethod(3), args);
    }

    protected static void launchNow(Class<? extends Application> appClass, String ... args) {
        Application.launch(appClass, (String[])args);
    }

    public final void init() throws CoreException {
        try {
            super.init();
            this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.ProgressNotification(0.1));
            this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.ProgressNotification(100.0));
            this.preInit();
            this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.ProgressNotification(0.3));
            this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.ProgressNotification(400.0));
            this.loadMessagesFiles();
            this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.ProgressNotification(0.4));
            this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.ProgressNotification(500.0));
            this.loadConfigurationFiles();
            this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.ProgressNotification(0.5));
            this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.ProgressNotification(600.0));
            JRebirthThread jrt = JRebirthThread.getThread();
            this.initializeExceptionHandler();
            jrt.prepare(this);
            this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.ProgressNotification(0.6));
            this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.ProgressNotification(700.0));
            this.preloadResources();
            this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.ProgressNotification(0.7));
            this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.ProgressNotification(800.0));
            this.preloadModules();
            this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.ProgressNotification(0.8));
            this.postInit();
            this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.ProgressNotification(1000.0));
            this.notifyPreloader((Preloader.PreloaderNotification)new Preloader.ProgressNotification(1.0));
        }
        catch (Exception e) {
            LOGGER.error(ApplicationMessages.INIT_ERROR, (Throwable)e, new Object[]{this.getClass().getSimpleName()});
            throw new CoreException((Throwable)e);
        }
    }

    protected abstract void preInit();

    protected abstract void postInit();

    public final void start(Stage primaryStage) throws CoreException {
        try {
            LOGGER.log(START_APPLICATION, new Object[]{this.getClass().getSimpleName()});
            this.stage = primaryStage;
            this.initializeStage();
            this.scene = this.buildScene();
            this.initializeScene();
            primaryStage.setScene(this.scene);
            JRebirthThread.getThread().start();
            primaryStage.show();
            LOGGER.log(STARTED_SUCCESSFULLY, new Object[]{this.getClass().getSimpleName()});
        }
        catch (CoreException ce) {
            LOGGER.error(START_ERROR, (Throwable)ce, new Object[]{this.getClass().getSimpleName()});
            throw new CoreException((Throwable)ce);
        }
    }

    private void loadConfigurationFiles() {
        Configuration conf = ClassUtility.getLastClassAnnotation(this.getClass(), Configuration.class);
        ResourceBuilders.PARAMETER_BUILDER.searchConfigurationFiles(conf.value(), conf.extension());
    }

    private void loadMessagesFiles() {
        Localized local = ClassUtility.getLastClassAnnotation(this.getClass(), Localized.class);
        ResourceBuilders.MESSAGE_BUILDER.searchMessagesFiles(local.value());
    }

    public final void stop() throws CoreException {
        try {
            LOGGER.log(STOP_APPLICATION, new Object[]{this.getClass().getSimpleName()});
            this.preStop();
            super.stop();
            if (this.getStage().isShowing()) {
                this.getStage().hide();
            }
            boolean firstTime = true;
            do {
                JRebirthThread.getThread().close();
                Thread.sleep(firstTime ? (long)((Integer)JRebirthParameters.CLOSE_RETRY_DELAY_FIRST.get()).intValue() : (long)((Integer)JRebirthParameters.CLOSE_RETRY_DELAY_OTHER.get()).intValue());
                if (!firstTime) continue;
                firstTime = false;
            } while (JRebirthThread.getThread().isAlive());
            this.postStop();
            LOGGER.log(STOPPED_SUCCESSFULLY, new Object[]{this.getClass().getSimpleName()});
        }
        catch (Exception e) {
            LOGGER.error(STOP_ERROR, (Throwable)e, new Object[]{this.getClass().getSimpleName(), e});
            throw new CoreException((Throwable)e);
        }
    }

    protected abstract void preStop();

    protected abstract void postStop();

    private void initializeStage() {
        this.stage.setTitle(this.getApplicationTitle());
        this.customizeStage(this.stage);
    }

    protected abstract void customizeStage(Stage var1);

    private void initializeScene() {
        final Stage currentStage = this.stage;
        final KeyCode fullKeyCode = this.getFullScreenKeyCode();
        final KeyCode iconKeyCode = this.getIconifiedKeyCode();
        if (fullKeyCode != null && iconKeyCode != null) {
            this.scene.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent event) {
                    if (fullKeyCode != null && fullKeyCode == event.getCode()) {
                        currentStage.setFullScreen(!currentStage.isFullScreen());
                        event.consume();
                    } else if (iconKeyCode != null && iconKeyCode == event.getCode()) {
                        currentStage.setIconified(!currentStage.isIconified());
                        event.consume();
                    }
                }
            });
        }
        this.customizeScene(this.scene);
        this.manageDefaultStyleSheet(this.scene);
    }

    public void preloadResources() {
        List<ResourceItem<?, ?, ?>> resourceList = this.getResourceToPreload();
        if (resourceList != null) {
            for (ResourceItem<?, ?, ?> resource : resourceList) {
                resource.get();
            }
        }
    }

    protected void preloadModules() {
        if (((Boolean)JRebirthParameters.PARSE_MODULE_CONFIG_FILE.get()).booleanValue() && this.hasModuleLibrary()) {
            Pattern filePattern = Pattern.compile(".*module\\.xml");
            Collection<String> list = ClasspathUtility.getClasspathResources(filePattern);
            for (String moduleFile : list) {
                List pairList = ModuleConfigFileParser.getRegistrations((String)moduleFile);
                for (Pair pair : pairList) {
                    Class interfaceClass = (Class)pair.getKey();
                    Class implClass = (Class)pair.getValue();
                    JRebirthThread.getThread().getFacade().getComponentFactory().register(interfaceClass, implClass);
                }
                for (Class componentClass : ModuleConfigFileParser.getWarmUp((String)moduleFile)) {
                    if (Command.class.isAssignableFrom(componentClass)) {
                        JRebirthThread.getThread().getFacade().getCommandFacade().retrieve(componentClass, new Object[0]);
                        continue;
                    }
                    if (Service.class.isAssignableFrom(componentClass)) {
                        JRebirthThread.getThread().getFacade().getServiceFacade().retrieve(componentClass, new Object[0]);
                        continue;
                    }
                    if (!Model.class.isAssignableFrom(componentClass)) continue;
                    JRebirthThread.getThread().getFacade().getUiFacade().retrieve(componentClass, new Object[0]);
                }
            }
        }
    }

    private boolean hasModuleLibrary() {
        boolean hasModuleLibrary = true;
        try {
            Class.forName("org.jrebirth.af.modular.ModuleConfigFileParser");
        }
        catch (ClassNotFoundException e) {
            hasModuleLibrary = false;
        }
        return hasModuleLibrary;
    }

    protected abstract List<? extends ResourceItem<?, ?, ?>> getResourceToPreload();

    protected abstract void customizeScene(Scene var1);

    protected void addCSS(Scene scene, StyleSheetItem styleSheetItem) {
        URL styleSheetURL = styleSheetItem.get();
        if (styleSheetURL == null) {
            LOGGER.error(CSS_LOADING_ERROR, new Object[]{styleSheetItem.toString(), JRebirthParameters.STYLE_FOLDER.get()});
        } else {
            scene.getStylesheets().add((Object)styleSheetURL.toExternalForm());
        }
    }

    protected String getApplicationTitle() {
        String name = (String)JRebirthParameters.APPLICATION_NAME.get();
        if (name.contains(PARAM)) {
            name = name.replace(PARAM, this.getShortClassName());
        }
        String version = (String)JRebirthParameters.APPLICATION_VERSION.get();
        StringBuilder sb = new StringBuilder(name);
        if (!"0.0.0".equals(version)) {
            sb.append(' ').append(version);
        }
        return sb.toString();
    }

    private String getShortClassName() {
        String name = this.getClass().getSimpleName();
        if (name.endsWith(APP_SUFFIX_CLASSNAME)) {
            name = name.substring(0, name.indexOf(APP_SUFFIX_CLASSNAME));
        }
        return name;
    }

    private void manageDefaultStyleSheet(Scene scene) {
        if (scene.getStylesheets().isEmpty()) {
            LOGGER.log(NO_CSS_DEFINED);
            this.addCSS(scene, JRebirthStyles.DEFAULT);
        }
    }

    protected final Scene buildScene() throws CoreException {
        return SceneBuilder.create().root(this.buildRootPane()).width((double)((Integer)JRebirthParameters.APPLICATION_SCENE_WIDTH.get()).intValue()).height((double)((Integer)JRebirthParameters.APPLICATION_SCENE_HEIGHT.get()).intValue()).fill((Paint)JRebirthColors.SCENE_BG_COLOR.get()).build();
    }

    protected P buildRootPane() throws CoreException {
        this.rootNode = (Pane)ClassUtility.buildGenericType(this.getClass(), Pane.class, new Object[0]);
        return this.rootNode;
    }

    protected void initializeExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(this.getDefaultUncaughtExceptionHandler());
        JRebirth.runIntoJAT(new AbstractJrbRunnable(ATTACH_JAT_UEH.getText(new Object[0])){

            @Override
            public void runInto() throws JRebirthThreadException {
                Thread.currentThread().setUncaughtExceptionHandler(AbstractApplication.this.getJatUncaughtExceptionHandler());
            }
        });
        JRebirth.runIntoJIT(new AbstractJrbRunnable(ATTACH_JIT_UEH.getText(new Object[0])){

            @Override
            public void runInto() throws JRebirthThreadException {
                Thread.currentThread().setUncaughtExceptionHandler(AbstractApplication.this.getJitUncaughtExceptionHandler());
            }
        });
    }

    public Stage getStage() {
        return this.stage;
    }

    public final Scene getScene() {
        return this.scene;
    }

    public P getRootNode() {
        return this.rootNode;
    }

    protected KeyCode getFullScreenKeyCode() {
        return KeyCode.F11;
    }

    protected KeyCode getIconifiedKeyCode() {
        return KeyCode.F10;
    }

    protected Thread.UncaughtExceptionHandler getDefaultUncaughtExceptionHandler() {
        return new DefaultUncaughtExceptionHandler();
    }

    protected Thread.UncaughtExceptionHandler getJatUncaughtExceptionHandler() {
        return new JatUncaughtExceptionHandler();
    }

    protected Thread.UncaughtExceptionHandler getJitUncaughtExceptionHandler() {
        return new JitUncaughtExceptionHandler();
    }

    public Thread.UncaughtExceptionHandler getPoolUncaughtExceptionHandler() {
        return new PoolUncaughtExceptionHandler();
    }
}

