/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.command;

import org.jrebirth.af.api.command.Command;
import org.jrebirth.af.api.command.CommandBean;
import org.jrebirth.af.api.concurrent.RunInto;
import org.jrebirth.af.api.concurrent.RunType;
import org.jrebirth.af.api.concurrent.RunnablePriority;
import org.jrebirth.af.api.facade.JRebirthEventType;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.api.wave.WaveBean;
import org.jrebirth.af.core.command.CommandRunnable;
import org.jrebirth.af.core.component.behavior.AbstractBehavioredComponent;
import org.jrebirth.af.core.concurrent.JRebirth;
import org.jrebirth.af.core.exception.CommandException;
import org.jrebirth.af.core.util.ClassUtility;
import org.jrebirth.af.core.wave.Builders;
import org.jrebirth.af.core.wave.DefaultWaveBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseCommand<WB extends WaveBean>
extends AbstractBehavioredComponent<Command>
implements CommandBean<WB> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractBaseCommand.class);
    protected RunType runIntoThread;
    protected RunnablePriority runnablePriority;
    private Class<WB> waveBeanClass;

    public AbstractBaseCommand() {
        this(null, null);
    }

    public AbstractBaseCommand(RunType runType, RunnablePriority priority) {
        RunInto ria = ClassUtility.getLastClassAnnotation(this.getClass(), RunInto.class);
        RunType runType2 = ria == null ? (runType == null ? RunType.JIT : runType) : (this.runIntoThread = ria.value());
        this.runnablePriority = ria == null ? (priority == null ? RunnablePriority.Normal : priority) : ria.priority();
        this.waveBeanClass = ClassUtility.getGenericClassAssigned(this.getClass(), WaveBean.class);
        if (this.waveBeanClass == null) {
            this.waveBeanClass = DefaultWaveBean.class;
        }
    }

    protected abstract void perform(Wave var1) throws CommandException;

    @Override
    protected void processWave(Wave wave) {
        LOGGER.warn(this.getClass() + " should manage custom code to handle the wave " + wave.toString() + " or unlisten this type");
    }

    public final Wave run() {
        return this.run(null);
    }

    public final Wave run(Wave wave) {
        Wave commandWave = wave == null ? Builders.callCommand(this.getClass()) : wave;
        JRebirth.run(this.getRunInto(), new CommandRunnable(this.getClass().getSimpleName(), this, commandWave));
        return commandWave;
    }

    final void innerRun(Wave wave) throws CommandException {
        this.beforePerform(wave);
        this.perform(wave);
        this.afterPerform(wave);
    }

    protected abstract void beforePerform(Wave var1);

    protected abstract void afterPerform(Wave var1);

    protected final RunType getRunInto() {
        return this.runIntoThread;
    }

    protected final RunnablePriority getRunnablePriority() {
        return this.runnablePriority;
    }

    protected void finalize() throws Throwable {
        this.getLocalFacade().getGlobalFacade().trackEvent(JRebirthEventType.DESTROY_COMMAND, null, this.getClass(), new String[0]);
        super.finalize();
    }

    public WB getWaveBean(Wave wave) {
        return (WB)wave.waveBean(this.waveBeanClass);
    }

    protected void fireConsumed(Wave wave) {
        LOGGER.trace(this.getClass().getSimpleName() + " consumes  " + wave.toString());
        wave.status(Wave.Status.Consumed);
    }

    protected void fireHandled(Wave wave) {
        LOGGER.trace(this.getClass().getSimpleName() + " handles  " + wave.toString());
        wave.status(Wave.Status.Handled);
    }

    protected void fireFailed(Wave wave) {
        LOGGER.trace(this.getClass().getSimpleName() + " has failed  " + wave.toString());
        wave.status(Wave.Status.Failed);
    }
}

