/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.command;

import org.jrebirth.af.api.exception.JRebirthThreadException;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.api.wave.WaveBean;
import org.jrebirth.af.core.command.AbstractBaseCommand;
import org.jrebirth.af.core.concurrent.AbstractJrbRunnable;
import org.jrebirth.af.core.exception.CommandException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CommandRunnable
extends AbstractJrbRunnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandRunnable.class);
    private final Wave wave;
    private final AbstractBaseCommand<? extends WaveBean> command;

    CommandRunnable(String runnableName, AbstractBaseCommand<? extends WaveBean> command, Wave wave) {
        super(runnableName, command.getRunnablePriority());
        this.command = command;
        this.wave = wave;
    }

    @Override
    protected void runInto() throws JRebirthThreadException {
        try {
            this.command.innerRun(this.wave);
        }
        catch (CommandException ce) {
            LOGGER.error("Command has failed :", (Throwable)((Object)ce));
            this.wave.status(Wave.Status.Failed);
        }
    }
}

