/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.command.basic;

import java.util.List;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.api.wave.WaveListener;
import org.jrebirth.af.core.command.single.internal.DefaultCommand;
import org.jrebirth.af.core.wave.JRebirthWaves;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainWaveCommand
extends DefaultCommand
implements WaveListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChainWaveCommand.class);
    private int index;
    private List<Wave> waveList;
    private Wave sourceWave;

    @Override
    protected void perform(Wave wave) {
        if (this.index == 0) {
            this.waveList = (List)wave.get(JRebirthWaves.CHAINED_WAVES);
            this.sourceWave = wave;
            this.fireHandled(this.sourceWave);
        }
        this.unqueueWaves();
    }

    @Override
    public void afterPerform(Wave wave) {
    }

    private void unqueueWaves() {
        Wave waveToRun = this.waveList.get(this.index);
        if (waveToRun == null) {
            ++this.index;
            if (this.waveList.size() > this.index) {
                this.unqueueWaves();
            }
        } else {
            LOGGER.trace("Unqueue wave N\u00b0 " + this.index + " >> " + waveToRun.toString());
            waveToRun.addWaveListener((WaveListener)this);
            this.sendWave(waveToRun);
        }
    }

    public void waveCreated(Wave wave) {
    }

    public void waveSent(Wave wave) {
    }

    public void waveProcessed(Wave wave) {
    }

    public void waveConsumed(Wave wave) {
    }

    public void waveHandled(Wave wave) {
        ++this.index;
        if (this.waveList.size() > this.index) {
            this.unqueueWaves();
        } else {
            this.fireHandled(this.sourceWave);
        }
    }

    public void waveFailed(Wave wave) {
        this.fireFailed(this.sourceWave);
    }

    public void waveCancelled(Wave wave) {
    }

    public void waveDestroyed(Wave wave) {
    }
}

