/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.command.basic.showmodel;

import javafx.scene.Node;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.core.command.basic.showmodel.DisplayModelWaveBean;
import org.jrebirth.af.core.command.single.ui.DefaultUIBeanCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachModelCommand
extends DefaultUIBeanCommand<DisplayModelWaveBean> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachModelCommand.class);

    @Override
    protected void perform(Wave wave) {
        Node createdNode = ((DisplayModelWaveBean)this.getWaveBean(wave)).showModel().getRootNode();
        if (createdNode == null) {
            LOGGER.warn("Impossible to attach model {} because the created node is null", (Object)((DisplayModelWaveBean)this.getWaveBean(wave)).showModelKey().toString());
        } else {
            if (((DisplayModelWaveBean)this.getWaveBean(wave)).uniquePlaceHolder() != null) {
                ((DisplayModelWaveBean)this.getWaveBean(wave)).uniquePlaceHolder().set((Object)createdNode);
            }
            if (((DisplayModelWaveBean)this.getWaveBean(wave)).childrenPlaceHolder() != null) {
                if (((DisplayModelWaveBean)this.getWaveBean(wave)).appendChild()) {
                    ((DisplayModelWaveBean)this.getWaveBean(wave)).childrenPlaceHolder().add((Object)createdNode);
                } else {
                    ((DisplayModelWaveBean)this.getWaveBean(wave)).childrenPlaceHolder().add(0, (Object)createdNode);
                }
            }
            if (((DisplayModelWaveBean)this.getWaveBean(wave)).uniquePlaceHolder() == null && ((DisplayModelWaveBean)this.getWaveBean(wave)).childrenPlaceHolder() == null) {
                LOGGER.warn("Impossible to attach model {}, no place holder found", (Object)((DisplayModelWaveBean)this.getWaveBean(wave)).showModelKey().toString());
            }
            if (((DisplayModelWaveBean)this.getWaveBean(wave)).appendChild()) {
                ((DisplayModelWaveBean)this.getWaveBean(wave)).showModel().doShowView(wave);
            }
        }
    }
}

