/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.command.basic.showmodel;

import javafx.scene.Node;
import org.jrebirth.af.api.ui.Model;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.core.command.basic.showmodel.DisplayModelWaveBean;
import org.jrebirth.af.core.command.single.ui.DefaultUIBeanCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetachModelCommand
extends DefaultUIBeanCommand<DisplayModelWaveBean> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DetachModelCommand.class);

    @Override
    protected void perform(Wave wave) {
        Model hideModel = this.getWaveBean(wave).hideModel();
        if (hideModel == null && this.getWaveBean(wave).hideModelKey() != null) {
            hideModel = (Model)this.getLocalFacade().getGlobalFacade().getUiFacade().retrieve(this.getWaveBean(wave).hideModelKey());
        }
        Node hideNode = null;
        if (hideModel == null) {
            LOGGER.warn("Impossible to dettach a model because hideModel is null");
        } else {
            hideModel.doHideView(wave);
            hideNode = hideModel.getRootNode();
            if (hideNode == null) {
                LOGGER.warn("Impossible to dettach model {} because the node is null", (Object)hideModel.getClass().getSimpleName());
            } else if (this.getWaveBean(wave).uniquePlaceHolder() != null) {
                this.getWaveBean(wave).uniquePlaceHolder().set(null);
            } else if (this.getWaveBean(wave).childrenPlaceHolder() != null) {
                this.getWaveBean(wave).childrenPlaceHolder().remove((Object)hideNode);
            } else {
                LOGGER.warn("Impossible to detach model {}, no place holder found", (Object)hideModel.getClass().getSimpleName());
            }
        }
    }

    @Override
    public DisplayModelWaveBean getWaveBean(Wave wave) {
        return (DisplayModelWaveBean)wave.waveBean(DisplayModelWaveBean.class);
    }
}

