/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.command.basic.showmodel;

import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.FadeTransitionBuilder;
import javafx.animation.PauseTransition;
import javafx.animation.PauseTransitionBuilder;
import javafx.animation.SequentialTransition;
import javafx.animation.SequentialTransitionBuilder;
import javafx.scene.Node;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.core.command.basic.showmodel.DisplayModelWaveBean;
import org.jrebirth.af.core.command.basic.showmodel.FadeInOutWaveBean;
import org.jrebirth.af.core.command.single.ui.DefaultUIBeanCommand;
import org.jrebirth.af.core.exception.CommandException;

public class FadeInOutCommand
extends DefaultUIBeanCommand<FadeInOutWaveBean> {
    @Override
    protected void initCommand() {
        super.initCommand();
    }

    @Override
    protected void perform(Wave wave) throws CommandException {
        Node node = this.getNode(wave);
        FadeInOutWaveBean waveBean = (FadeInOutWaveBean)this.getWaveBean(wave);
        FadeTransition fadeIn = ((FadeTransitionBuilder)((FadeTransitionBuilder)FadeTransitionBuilder.create().autoReverse(false)).cycleCount(1)).fromValue(0.0).toValue(1.0).duration(waveBean.fadingInDuration()).node(node).build();
        PauseTransition pause = PauseTransitionBuilder.create().duration(waveBean.showDuration()).build();
        FadeTransition fadeOut = ((FadeTransitionBuilder)((FadeTransitionBuilder)FadeTransitionBuilder.create().autoReverse(false)).cycleCount(1)).fromValue(1.0).toValue(0.0).duration(waveBean.fadingOutDuration()).node(node).build();
        SequentialTransition pt = SequentialTransitionBuilder.create().children(new Animation[]{fadeIn, pause, fadeOut}).build();
        pt.play();
    }

    private Node getNode(Wave wave) {
        Node node = ((FadeInOutWaveBean)this.getWaveBean(wave)).node();
        if (node == null && wave.hasWaveBean(DisplayModelWaveBean.class)) {
            node = ((DisplayModelWaveBean)wave.waveBean(DisplayModelWaveBean.class)).showModel().getRootNode();
        }
        return node;
    }
}

