/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.command.basic.showmodel;

import javafx.animation.FadeTransitionBuilder;
import javafx.animation.ParallelTransition;
import javafx.animation.ParallelTransitionBuilder;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.util.Duration;
import org.jrebirth.af.api.concurrent.RunInto;
import org.jrebirth.af.api.concurrent.RunType;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.core.command.basic.showmodel.DisplayModelWaveBean;
import org.jrebirth.af.core.command.single.AbstractSingleCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunInto(value=RunType.JAT)
public class FadeTransitionCommand
extends AbstractSingleCommand<DisplayModelWaveBean> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FadeTransitionCommand.class);

    @Override
    protected void initCommand() {
    }

    @Override
    protected void perform(final Wave wave) {
        Node newNode;
        Node oldNode;
        Node node = oldNode = ((DisplayModelWaveBean)this.getWaveBean(wave)).hideModel() == null ? null : ((DisplayModelWaveBean)this.getWaveBean(wave)).hideModel().getRootNode();
        if (oldNode == null) {
            ObservableList<Node> parentContainer = ((DisplayModelWaveBean)this.getWaveBean(wave)).childrenPlaceHolder();
            oldNode = parentContainer.size() > 1 ? (Node)parentContainer.get(((DisplayModelWaveBean)this.getWaveBean(wave)).childrenPlaceHolder().size() - 1) : null;
        }
        Node node2 = newNode = ((DisplayModelWaveBean)this.getWaveBean(wave)).showModel() == null ? null : ((DisplayModelWaveBean)this.getWaveBean(wave)).showModel().getRootNode();
        if (oldNode != null || newNode != null) {
            ParallelTransition animation = ParallelTransitionBuilder.create().build();
            if (oldNode != null) {
                animation.getChildren().add((Object)FadeTransitionBuilder.create().duration(Duration.millis((double)600.0)).node(oldNode).fromValue(1.0).toValue(0.0).build());
            }
            if (newNode != null) {
                animation.getChildren().add((Object)FadeTransitionBuilder.create().duration(Duration.millis((double)600.0)).node(newNode).fromValue(0.0).toValue(1.0).build());
            }
            final Node oldNodeLink = oldNode;
            animation.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent arg0) {
                    if (oldNodeLink != null) {
                        ((DisplayModelWaveBean)FadeTransitionCommand.this.getWaveBean(wave)).childrenPlaceHolder().remove((Object)oldNodeLink);
                        LOGGER.info("Remove " + oldNodeLink.toString() + " from stack container");
                    }
                    ((DisplayModelWaveBean)FadeTransitionCommand.this.getWaveBean(wave)).showModel().doShowView(wave);
                }
            });
            animation.playFromStart();
        }
    }

    @Override
    protected void initInnerComponents() {
    }
}

