/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.command.basic.showmodel;

import org.jrebirth.af.api.exception.CoreRuntimeException;
import org.jrebirth.af.api.key.UniqueKey;
import org.jrebirth.af.api.ui.Model;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.core.command.basic.showmodel.DisplayModelWaveBean;
import org.jrebirth.af.core.command.single.pool.DefaultPoolBeanCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareModelCommand
extends DefaultPoolBeanCommand<DisplayModelWaveBean> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrepareModelCommand.class);

    @Override
    protected void perform(Wave wave) {
        UniqueKey<? extends Model> showModelKey = this.getWaveBean(wave).showModelKey();
        if (showModelKey == null) {
            LOGGER.error("ModelClass is null");
            throw new CoreRuntimeException("Illegal action : Model Class is null");
        }
        Model modelInstance = (Model)this.getLocalFacade().getGlobalFacade().getUiFacade().retrieve(showModelKey);
        if (modelInstance == null) {
            LOGGER.error("Model " + showModelKey.getClassField().getSimpleName() + " couldn't be created");
            throw new CoreRuntimeException("Illegal action : Model Instance is null: " + showModelKey.getClassField().getName());
        }
        this.getWaveBean(wave).showModel(modelInstance);
    }

    @Override
    public DisplayModelWaveBean getWaveBean(Wave wave) {
        return (DisplayModelWaveBean)wave.waveBean(DisplayModelWaveBean.class);
    }
}

