/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.command.basic.stage;

import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.core.command.basic.stage.StageWaveBean;
import org.jrebirth.af.core.command.single.ui.DefaultUIBeanCommand;
import org.jrebirth.af.core.service.basic.StageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StageCommand
extends DefaultUIBeanCommand<StageWaveBean> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StageCommand.class);

    @Override
    protected void perform(Wave wave) {
        StageService ss = this.getService(StageService.class, new Object[0]);
        LOGGER.info("Trigger stage action " + (Object)((Object)this.getWaveBean(wave).action()));
        switch (this.getWaveBean(wave).action()) {
            case show: {
                ss.doOpenStage(wave);
                break;
            }
            case hide: {
                ss.doCloseStage(wave);
                break;
            }
            case destroy: {
                ss.doDestroyStage(wave);
                break;
            }
            default: {
                LOGGER.error("Undefined StageAction");
            }
        }
    }

    @Override
    public StageWaveBean getWaveBean(Wave wave) {
        return (StageWaveBean)wave.waveBean(StageWaveBean.class);
    }
}

