/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.command.multi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jrebirth.af.api.annotation.Sequential;
import org.jrebirth.af.api.command.Command;
import org.jrebirth.af.api.command.MultiCommand;
import org.jrebirth.af.api.concurrent.RunType;
import org.jrebirth.af.api.concurrent.RunnablePriority;
import org.jrebirth.af.api.exception.CoreException;
import org.jrebirth.af.api.exception.CoreRuntimeException;
import org.jrebirth.af.api.key.UniqueKey;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.api.wave.WaveBean;
import org.jrebirth.af.api.wave.WaveListener;
import org.jrebirth.af.api.wave.contract.WaveData;
import org.jrebirth.af.core.command.AbstractBaseCommand;
import org.jrebirth.af.core.key.Key;
import org.jrebirth.af.core.util.ClassUtility;
import org.jrebirth.af.core.wave.Builders;
import org.jrebirth.af.core.wave.WaveDataBase;

public abstract class AbstractMultiCommand<WB extends WaveBean>
extends AbstractBaseCommand<WB>
implements MultiCommand<WB>,
WaveListener {
    private static final Boolean DEFAULT_SEQUENTIAL_VALUE = Boolean.TRUE;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private List<UniqueKey<? extends Command>> subCommandList;
    private final List<Wave> pendingWaves = Collections.synchronizedList(new ArrayList());
    private boolean sequential;
    private int commandRunIndex;
    private Wave waveSource;
    private final AtomicBoolean cancelRequested = new AtomicBoolean(false);

    public AbstractMultiCommand(RunType runInto) {
        this(runInto, true);
        super.initSequential(null);
    }

    public AbstractMultiCommand(boolean sequential) {
        this(null, null, sequential);
    }

    public AbstractMultiCommand(RunType runInto, boolean sequential) {
        this(runInto, null, sequential);
    }

    public AbstractMultiCommand(RunType runInto, RunnablePriority priority, boolean sequential) {
        super(runInto, priority);
        this.initSequential(sequential);
    }

    private void initSequential(Boolean sequential) {
        Sequential seq = ClassUtility.getLastClassAnnotation(this.getClass(), Sequential.class);
        this.setSequential(seq == null ? (sequential == null ? DEFAULT_SEQUENTIAL_VALUE : sequential).booleanValue() : seq.value());
    }

    protected boolean isSequential() {
        return this.sequential;
    }

    protected void setSequential(boolean sequential) {
        this.sequential = sequential;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void ready() throws CoreException {
        AbstractMultiCommand abstractMultiCommand = this;
        synchronized (abstractMultiCommand) {
            this.subCommandList = this.defineSubCommand();
            if (this.subCommandList == null || this.subCommandList.isEmpty()) {
                throw new CoreRuntimeException("Warning, 'defineSubCommand' should return at least one Command Key.");
            }
            for (UniqueKey<? extends Command> commandKey : this.subCommandList) {
                this.getLocalFacade().retrieve(commandKey);
            }
        }
        this.initCommand();
    }

    protected abstract void initCommand();

    protected abstract List<UniqueKey<? extends Command>> defineSubCommand();

    @Override
    public void beforePerform(Wave wave) {
        this.running.set(true);
    }

    @Override
    public void afterPerform(Wave wave) {
    }

    public boolean isRunning() {
        return this.running.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void perform(Wave wave) {
        if (!this.cancelRequested.get()) {
            if (this.isSequential()) {
                AbstractMultiCommand abstractMultiCommand = this;
                synchronized (abstractMultiCommand) {
                    if (this.commandRunIndex == 0) {
                        this.waveSource = wave;
                        this.fireConsumed(this.waveSource);
                    }
                    if (this.subCommandList.size() > this.commandRunIndex) {
                        Wave subCommandWave = Builders.callCommand(this.subCommandList.get(this.commandRunIndex).getClassField()).waveBeanList(wave.waveBeanList()).addDatas((WaveData[])wave.waveDatas().toArray(new WaveDataBase[0])).addWaveListener((WaveListener)this);
                        this.sendWave(subCommandWave);
                    }
                }
            }
            this.waveSource = wave;
            AbstractMultiCommand abstractMultiCommand = this;
            synchronized (abstractMultiCommand) {
                for (UniqueKey<? extends Command> commandKey : this.subCommandList) {
                    Wave commandWave = ((Command)this.getLocalFacade().retrieve(commandKey)).run();
                    commandWave.addWaveListener((WaveListener)this);
                    this.pendingWaves.add(commandWave);
                }
            }
        }
    }

    public void waveConsumed(Wave wave) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waveHandled(Wave wave) {
        AbstractMultiCommand abstractMultiCommand = this;
        synchronized (abstractMultiCommand) {
            if (this.isSequential()) {
                ++this.commandRunIndex;
                if (this.subCommandList.size() > this.commandRunIndex) {
                    this.perform(wave);
                } else {
                    this.running.set(false);
                    this.fireHandled(this.waveSource);
                }
            } else {
                this.pendingWaves.remove(wave);
                if (this.pendingWaves.isEmpty()) {
                    this.fireHandled(this.waveSource);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waveFailed(Wave wave) {
        if (this.sequential) {
            AbstractMultiCommand abstractMultiCommand = this;
            synchronized (abstractMultiCommand) {
                this.fireFailed(this.waveSource);
            }
        }
        AbstractMultiCommand abstractMultiCommand = this;
        synchronized (abstractMultiCommand) {
            this.fireFailed(this.waveSource);
        }
    }

    public void waveCancelled(Wave wave) {
    }

    public void waveDestroyed(Wave wave) {
    }

    public void waveCreated(Wave wave) {
    }

    public void waveSent(Wave wave) {
    }

    public void waveProcessed(Wave wave) {
    }

    protected UniqueKey<? extends Command> getCommandKey(Class<? extends Command> commandClass, Object ... keyPart) {
        return Key.create(commandClass, keyPart);
    }
}

