/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.component.basic;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jrebirth.af.api.annotation.AfterInit;
import org.jrebirth.af.api.annotation.BeforeInit;
import org.jrebirth.af.api.annotation.OnRelease;
import org.jrebirth.af.api.annotation.Releasable;
import org.jrebirth.af.api.annotation.SkipAnnotation;
import org.jrebirth.af.api.command.Command;
import org.jrebirth.af.api.command.CommandBean;
import org.jrebirth.af.api.component.basic.Component;
import org.jrebirth.af.api.component.basic.InnerComponent;
import org.jrebirth.af.api.component.behavior.Behavior;
import org.jrebirth.af.api.exception.CoreException;
import org.jrebirth.af.api.exception.CoreRuntimeException;
import org.jrebirth.af.api.exception.JRebirthThreadException;
import org.jrebirth.af.api.facade.JRebirthEventType;
import org.jrebirth.af.api.link.Notifier;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.api.service.Service;
import org.jrebirth.af.api.ui.Model;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.api.wave.WaveBean;
import org.jrebirth.af.api.wave.WaveGroup;
import org.jrebirth.af.api.wave.checker.WaveChecker;
import org.jrebirth.af.api.wave.contract.WaveData;
import org.jrebirth.af.api.wave.contract.WaveType;
import org.jrebirth.af.core.concurrent.AbstractJrbRunnable;
import org.jrebirth.af.core.concurrent.JRebirth;
import org.jrebirth.af.core.concurrent.JrbReferenceRunnable;
import org.jrebirth.af.core.link.AbstractReady;
import org.jrebirth.af.core.link.ComponentEnhancer;
import org.jrebirth.af.core.link.LinkMessages;
import org.jrebirth.af.core.log.JRLoggerFactory;
import org.jrebirth.af.core.util.CheckerUtility;
import org.jrebirth.af.core.util.ClassUtility;
import org.jrebirth.af.core.util.ObjectUtility;
import org.jrebirth.af.core.wave.Builders;

@SkipAnnotation(value=false)
public abstract class AbstractComponent<C extends Component<C>>
extends AbstractReady<C>
implements Component<C>,
LinkMessages {
    public static final String PROCESS_WAVE_METHOD_NAME = "processWave";
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(AbstractComponent.class);
    private Map<String, List<Method>> lifecycleMethod;
    protected Component<?> rootComponent;
    protected Map<InnerComponent<?>, Component<?>> innerComponentMap;
    protected List<Component<?>> innerComponentList;

    private Notifier getNotifier() {
        return this.getLocalFacade().getGlobalFacade().getNotifier();
    }

    public final void listen(WaveType ... waveTypes) {
        this.listen((WaveChecker)null, (Method)null, waveTypes);
    }

    public final void listen(WaveChecker waveChecker, WaveType ... waveTypes) {
        this.listen(waveChecker, (Method)null, waveTypes);
    }

    private String getWaveTypesString(WaveType[] waveTypes) {
        StringBuilder sb = new StringBuilder();
        for (WaveType waveType : waveTypes) {
            sb.append(waveType.toString()).append(" ");
        }
        return sb.toString();
    }

    public final void listen(final WaveChecker waveChecker, final Method method, final WaveType ... waveTypes) {
        CheckerUtility.checkWaveTypeContract(this.getClass(), waveTypes);
        final AbstractComponent waveReady = this;
        LOGGER.trace(LinkMessages.LISTEN_WAVE_TYPE, new Object[]{this.getWaveTypesString(waveTypes), waveReady.getClass().getSimpleName()});
        JRebirth.runIntoJIT(new AbstractJrbRunnable(LISTEN_WAVE_TYPE.getText(new Object[]{this.getWaveTypesString(waveTypes), waveReady.getClass().getSimpleName()})){

            @Override
            public void runInto() throws JRebirthThreadException {
                AbstractComponent.this.getNotifier().listen(waveReady, waveChecker, method, waveTypes);
            }
        });
    }

    public final void unlisten(final WaveType ... waveTypes) {
        final AbstractComponent waveReady = this;
        LOGGER.trace(LinkMessages.UNLISTEN_WAVE_TYPE, new Object[]{this.getWaveTypesString(waveTypes), waveReady.getClass().getSimpleName()});
        JRebirth.runIntoJIT(new AbstractJrbRunnable(UNLISTEN_WAVE_TYPE.getText(new Object[]{this.getWaveTypesString(waveTypes), waveReady.getClass().getSimpleName()})){

            @Override
            protected void runInto() throws JRebirthThreadException {
                AbstractComponent.this.getNotifier().unlisten(waveReady, waveTypes);
            }
        });
    }

    public final void sendWave(Wave wave) {
        if (wave.fromClass() == null) {
            wave.fromClass(this.getClass());
        }
        this.sendWaveIntoJit(wave);
    }

    public final <WB extends WaveBean> Wave sendWave(WaveType waveType, WB waveBean) {
        return this.sendWaveIntoJit(this.createWave(WaveGroup.UNDEFINED, waveType, (Class)null, waveBean));
    }

    public final Wave sendWave(WaveType waveType, WaveData<?> ... waveData) {
        return this.sendWaveIntoJit(this.createWave(WaveGroup.UNDEFINED, waveType, null, waveData));
    }

    public final <WB extends WaveBean> Wave callCommand(Class<? extends CommandBean<WB>> commandClass, WB waveBean) {
        return this.sendWaveIntoJit(this.createWave(WaveGroup.CALL_COMMAND, null, commandClass, waveBean));
    }

    public final Wave callCommand(Class<? extends Command> commandClass, WaveData<?> ... data) {
        return this.sendWaveIntoJit(this.createWave(WaveGroup.CALL_COMMAND, null, commandClass, data));
    }

    public final Wave returnData(Class<? extends Service> serviceClass, WaveType waveType, WaveData<?> ... data) {
        return this.sendWaveIntoJit(this.createWave(WaveGroup.RETURN_DATA, waveType, serviceClass, data));
    }

    public final Wave attachUi(Class<? extends Model> modelClass, WaveData<?> ... data) {
        return this.sendWaveIntoJit(this.createWave(WaveGroup.ATTACH_UI, null, modelClass, data));
    }

    private Wave sendWaveIntoJit(final Wave wave) {
        CheckerUtility.checkWave(wave);
        wave.status(Wave.Status.Sent);
        JRebirth.runIntoJIT(new AbstractJrbRunnable(SEND_WAVE.getText(new Object[]{wave.toString()})){

            @Override
            public void runInto() throws JRebirthThreadException {
                AbstractComponent.this.getNotifier().sendWave(wave);
            }
        });
        return wave;
    }

    private Wave createWave(WaveGroup waveGroup, WaveType waveType, Class<?> componentClass, WaveData<?> ... waveData) {
        Wave wave = Builders.wave().waveGroup(waveGroup).waveType(waveType).fromClass(this.getClass()).componentClass(componentClass).addDatas(waveData);
        this.getLocalFacade().getGlobalFacade().trackEvent(JRebirthEventType.CREATE_WAVE, this.getClass(), wave.getClass(), new String[0]);
        return wave;
    }

    private Wave createWave(WaveGroup waveGroup, WaveType waveType, Class<?> componentClass, WaveBean waveBean) {
        Wave wave = Builders.wave().waveGroup(waveGroup).waveType(waveType).fromClass(this.getClass()).componentClass(componentClass).waveBean(waveBean);
        this.getLocalFacade().getGlobalFacade().trackEvent(JRebirthEventType.CREATE_WAVE, this.getClass(), wave.getClass(), new String[0]);
        return wave;
    }

    protected abstract void processWave(Wave var1);

    private Component<?> getWaveReady() {
        return this;
    }

    private void callAnnotatedMethod(Class<? extends Annotation> annotationClass) {
        if (this.lifecycleMethod.get(annotationClass.getName()) != null) {
            for (Method method : this.lifecycleMethod.get(annotationClass.getName())) {
                try {
                    ClassUtility.callMethod(method, this, new Object[0]);
                }
                catch (CoreException e) {
                    LOGGER.error(CALL_ANNOTATED_METHOD_ERROR, (Throwable)e);
                }
            }
        }
    }

    protected abstract void ready() throws CoreException;

    public void setup() throws CoreException {
        boolean canProcessAnnotation = ComponentEnhancer.canProcessAnnotation(this.getClass());
        if (canProcessAnnotation) {
            ComponentEnhancer.injectComponent(this);
            this.lifecycleMethod = ComponentEnhancer.defineLifecycleMethod(this);
            ComponentEnhancer.manageOnWaveAnnotation(this);
        }
        this.callAnnotatedMethod(BeforeInit.class);
        this.manageOptionalData();
        if (canProcessAnnotation) {
            ComponentEnhancer.injectInnerComponent(this);
        }
        this.initInternalInnerComponents();
        this.ready();
        this.callAnnotatedMethod(AfterInit.class);
    }

    protected abstract void manageOptionalData();

    public boolean release() {
        boolean released = false;
        if (ObjectUtility.checkAllMethodReturnTrue(this, ClassUtility.getAnnotatedMethods(this.getClass(), Releasable.class))) {
            JRebirth.runIntoJIT(new JrbReferenceRunnable("Release " + this.getClass().getCanonicalName(), this::internalRelease));
            released = true;
        }
        return released;
    }

    private void internalRelease() {
        this.callAnnotatedMethod(OnRelease.class);
        if (this.getLocalFacade() != null) {
            this.getLocalFacade().unregister(this.getKey());
        }
        if (this.getInnerComponentList().isPresent()) {
            ArrayList toRemove = new ArrayList();
            for (Component<?> component : this.getInnerComponentList().get()) {
                component.release();
                toRemove.add(component);
            }
            for (Component component : toRemove) {
                this.getInnerComponentList().get().remove(component);
                this.getInnerComponentMap().get().remove(component.getKey());
            }
        }
    }

    public final <IC extends Component<?>> void addInnerComponent(InnerComponent<IC> innerComponent) {
        if (!this.getInnerComponentMap().isPresent()) {
            this.innerComponentMap = new IdentityHashMap(10);
            this.innerComponentList = new ArrayList();
        }
        if (!this.innerComponentMap.containsKey(innerComponent)) {
            Class innerComponentClass = innerComponent.getKey().getClassField();
            Component childComponent = null;
            if (Command.class.isAssignableFrom(innerComponentClass)) {
                childComponent = (Component)this.getLocalFacade().getGlobalFacade().getCommandFacade().retrieve(innerComponent.getKey());
            } else if (Service.class.isAssignableFrom(innerComponentClass)) {
                childComponent = (Component)this.getLocalFacade().getGlobalFacade().getServiceFacade().retrieve(innerComponent.getKey());
            } else if (Model.class.isAssignableFrom(innerComponentClass)) {
                childComponent = (Component)this.getLocalFacade().getGlobalFacade().getUiFacade().retrieve(innerComponent.getKey());
            } else if (Behavior.class.isAssignableFrom(innerComponentClass)) {
                throw new CoreRuntimeException("Behaviors can not be used as Inner EnhancedComponent");
            }
            if (childComponent == null) {
                throw new CoreRuntimeException("Impossible to create Inner EnhancedComponent");
            }
            this.innerComponentMap.put(innerComponent, childComponent);
            this.innerComponentList.add(childComponent);
            childComponent.setRootComponent((Component)this);
        }
    }

    public final <IC extends Component<?>> IC getInnerComponent(InnerComponent<IC> innerModel) {
        if (!this.getInnerComponentMap().isPresent() || !this.getInnerComponentMap().get().containsKey(innerModel)) {
            this.addInnerComponent(innerModel);
        }
        return (IC)this.getInnerComponentMap().get().get(innerModel);
    }

    public Component<?> getRootComponent() {
        return this.rootComponent;
    }

    public void setRootComponent(Component<?> rootComponent) {
        this.rootComponent = rootComponent;
    }

    protected final void initInternalInnerComponents() {
        this.initInnerComponents();
    }

    protected abstract void initInnerComponents();

    protected Optional<Map<InnerComponent<?>, Component<?>>> getInnerComponentMap() {
        return Optional.ofNullable(this.innerComponentMap);
    }

    protected Optional<List<Component<?>>> getInnerComponentList() {
        return Optional.ofNullable(this.innerComponentList);
    }
}

