/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.component.behavior;

import java.util.List;
import java.util.Optional;
import org.jrebirth.af.api.annotation.SkipAnnotation;
import org.jrebirth.af.api.component.behavior.Behavior;
import org.jrebirth.af.api.component.behavior.BehaviorData;
import org.jrebirth.af.api.component.behavior.BehavioredComponent;
import org.jrebirth.af.api.key.UniqueKey;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.core.component.basic.AbstractComponent;
import org.jrebirth.af.core.key.Key;
import org.jrebirth.af.core.link.LinkMessages;
import org.jrebirth.af.core.log.JRLoggerFactory;
import org.jrebirth.af.core.util.MultiMap;

@SkipAnnotation(value=false)
public abstract class AbstractBehavioredComponent<C extends BehavioredComponent<C>>
extends AbstractComponent<C>
implements BehavioredComponent<C>,
LinkMessages {
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(AbstractBehavioredComponent.class);
    private MultiMap<Class<? extends Behavior<?>>, Behavior<?>> behaviors;

    @Override
    protected void manageOptionalData() {
        for (Object data : this.getKey().getOptionalData()) {
            if (data instanceof BehaviorData) {
                this.addBehavior((BD)((BehaviorData)data));
                continue;
            }
            if (!(data instanceof Class) || !((Class)data).isAssignableFrom(Behavior.class)) continue;
            this.addBehavior((BD)((BehaviorData)((Class)data)));
        }
    }

    public boolean hasBehavior(Class<Behavior<?>> behaviorClass) {
        return this.behaviors != null && this.behaviors.containsKey(behaviorClass);
    }

    public <BD extends BehaviorData, B extends Behavior<BD>> C addBehavior(Class<B> behaviorClass) {
        UniqueKey<B> key = Key.create(behaviorClass, new Object[]{this}, new Object[]{this.getKey()});
        Behavior behavior = (Behavior)this.getLocalFacade().getGlobalFacade().getBehaviorFacade().retrieve(key);
        this.addBehavior(behavior);
        return (C)this;
    }

    public <BD extends BehaviorData> C addBehavior(BD data) {
        for (Class behaviorClass : data.getBehaviors()) {
            Object[] optionalData = new Object[]{data, this};
            UniqueKey key = Key.create(behaviorClass, optionalData, new Object[]{this.getKey()});
            this.addBehavior((Behavior)this.getLocalFacade().getGlobalFacade().getBehaviorFacade().retrieve(key));
        }
        return (C)this;
    }

    private <B extends Behavior<?>> void addBehavior(B behavior) {
        if (this.behaviors == null) {
            this.behaviors = new MultiMap();
        }
        LOGGER.log(ADD_BEHAVIOR, new Object[]{behavior.getClass().getCanonicalName(), this.getClass().getCanonicalName()});
        this.behaviors.add(behavior.getClass(), behavior);
    }

    public <BD extends BehaviorData, B extends Behavior<BD>> B getBehavior(Class<B> behaviorClass) {
        Optional oBehavior;
        Behavior behavior = null;
        if (this.behaviors == null && this.behaviors.get(behaviorClass) instanceof List && (oBehavior = this.behaviors.get(behaviorClass).stream().findFirst()).isPresent()) {
            behavior = oBehavior.orElse(null);
        }
        return (B)behavior;
    }

    public <BD extends BehaviorData, B extends Behavior<BD>> BD getBehaviorData(Class<B> behaviorClass) {
        BehaviorData data = null;
        B behavior = this.getBehavior(behaviorClass);
        if (behavior != null) {
            data = behavior.getData();
        }
        return (BD)data;
    }
}

