/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.component.factory;

import org.jrebirth.af.api.component.basic.Component;
import org.jrebirth.af.api.component.factory.ComponentFactory;
import org.jrebirth.af.api.exception.CoreException;
import org.jrebirth.af.api.exception.CoreRuntimeException;
import org.jrebirth.af.core.facade.FacadeMessages;
import org.jrebirth.af.core.util.MultiMap;

public final class AnnotatedComponentFactory
implements ComponentFactory,
FacadeMessages {
    private final MultiMap<Class<?>, Class<?>> implementations = new MultiMap();

    public void register(Class<? extends Component<?>> interfaceClass, Class<? extends Component<?>> implClass) {
        if (!interfaceClass.isAssignableFrom(implClass)) {
            throw new CoreRuntimeException("");
        }
        this.implementations.add(interfaceClass, implClass);
    }

    public <R> R buildComponent(Class<R> clazz) throws CoreException {
        try {
            R component = null;
            component = clazz.isInterface() ? (R)((Class)this.implementations.get(clazz).stream().findFirst().get()).newInstance() : (R)clazz.newInstance();
            return component;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CoreException(COMPONENT_BUILD_ERROR.getText(new Object[]{clazz.getName()}), (Throwable)e);
        }
    }
}

