/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.concurrent;

import java.time.Instant;
import org.jrebirth.af.api.concurrent.JRebirthRunnable;
import org.jrebirth.af.api.concurrent.RunnablePriority;
import org.jrebirth.af.api.exception.JRebirthThreadException;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.core.concurrent.ConcurrentMessages;
import org.jrebirth.af.core.log.JRLoggerFactory;

public abstract class AbstractJrbRunnable
implements JRebirthRunnable,
ConcurrentMessages {
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(AbstractJrbRunnable.class);
    private final String runnableName;
    private final RunnablePriority priority;
    private final Instant creationTime = Instant.now();

    public AbstractJrbRunnable(String runnableName) {
        this(runnableName, RunnablePriority.Normal);
    }

    public AbstractJrbRunnable(String runnableName, RunnablePriority priority) {
        this.runnableName = runnableName;
        this.priority = priority;
    }

    public final void run() {
        LOGGER.trace(RUN_IT, new Object[]{this.runnableName});
        try {
            this.runInto();
        }
        catch (JRebirthThreadException jte) {
            LOGGER.error(THREAD_ERROR, (Throwable)jte, new Object[]{jte.getMessage()});
        }
    }

    protected abstract void runInto() throws JRebirthThreadException;

    public String toString() {
        return "JRebirthRunnable - " + this.runnableName;
    }

    public RunnablePriority getPriority() {
        return this.priority;
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }
}

