/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.facade;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.jrebirth.af.api.command.Command;
import org.jrebirth.af.api.component.basic.Component;
import org.jrebirth.af.api.exception.CoreException;
import org.jrebirth.af.api.exception.CoreRuntimeException;
import org.jrebirth.af.api.exception.JRebirthThreadException;
import org.jrebirth.af.api.facade.FacadeReady;
import org.jrebirth.af.api.facade.GlobalFacade;
import org.jrebirth.af.api.facade.JRebirthEventType;
import org.jrebirth.af.api.facade.LocalFacade;
import org.jrebirth.af.api.key.UniqueKey;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.api.service.Service;
import org.jrebirth.af.api.ui.Model;
import org.jrebirth.af.core.facade.AbstractGlobalReady;
import org.jrebirth.af.core.facade.FacadeMessages;
import org.jrebirth.af.core.key.Key;
import org.jrebirth.af.core.log.JRLoggerFactory;

public abstract class AbstractFacade<R extends FacadeReady<R>>
extends AbstractGlobalReady
implements LocalFacade<R>,
FacadeMessages {
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(AbstractFacade.class);
    private final Map<UniqueKey<? extends R>, WeakReference<R>> componentMap = Collections.synchronizedMap(new WeakHashMap());

    public AbstractFacade(GlobalFacade globalFacade) {
        super(globalFacade);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends R> void register(UniqueKey<E> uniqueKey, E readyObject) {
        Map<UniqueKey<? extends R>, WeakReference<R>> map = this.componentMap;
        synchronized (map) {
            readyObject.setKey(uniqueKey);
            readyObject.setLocalFacade((LocalFacade)this);
            this.componentMap.put(readyObject.getKey(), new WeakReference<E>(readyObject));
        }
    }

    public <E extends R> void register(E readyObject, Object ... keyPart) {
        this.register(Key.create(readyObject.getClass(), keyPart), readyObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends R> void unregister(UniqueKey<E> uniqueKey) {
        Map<UniqueKey<? extends R>, WeakReference<R>> map = this.componentMap;
        synchronized (map) {
            E readyObject = this.getReadyObject(uniqueKey);
            if (readyObject != null) {
                if (readyObject instanceof Component) {
                    try {
                        this.getGlobalFacade().getNotifier().unlistenAll((Component)readyObject);
                    }
                    catch (JRebirthThreadException e) {
                        LOGGER.error(UNLISTEN_ALL_ERROR, new Object[]{readyObject.getClass().getSimpleName(), e});
                    }
                }
                readyObject.setKey(null);
                readyObject.setLocalFacade(null);
            }
            this.componentMap.remove(uniqueKey);
        }
    }

    public <E extends R> void unregister(E readyObject, Object ... keyPart) {
        this.unregister(Key.create(readyObject.getClass(), keyPart));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends R> boolean exists(UniqueKey<E> uniqueKey) {
        boolean res;
        Map<UniqueKey<? extends R>, WeakReference<R>> map = this.componentMap;
        synchronized (map) {
            res = this.componentMap.containsKey(uniqueKey) && this.componentMap.get(uniqueKey).get() != null;
        }
        return res;
    }

    public <E extends R> boolean exists(Class<E> clazz, Object ... keyPart) {
        return this.exists(Key.create(clazz, keyPart));
    }

    public <E extends R> List<E> retrieveAll(UniqueKey<E> uniqueKey) {
        return this.componentMap.entrySet().stream().filter(entry -> ((UniqueKey)entry.getKey()).getClassField() == uniqueKey.getClassField()).map(e -> (FacadeReady)((WeakReference)e.getValue()).get()).filter(e -> e != null).collect(Collectors.toList());
    }

    public <E extends R> E retrieve(UniqueKey<E> uniqueKey) {
        E readyObject = this.getReadyObject(uniqueKey);
        if (readyObject == null) {
            try {
                readyObject = this.buildComponent(uniqueKey);
                this.register(uniqueKey, readyObject);
                readyObject.setup();
            }
            catch (CoreException ce) {
                LOGGER.error(COMPONENT_RETRIEVAL_ERROR, (Throwable)ce);
                throw new CoreRuntimeException((Throwable)ce);
            }
        }
        return readyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends R> E getReadyObject(UniqueKey<E> uniqueKey) {
        FacadeReady readyObject = null;
        Map<UniqueKey<? extends R>, WeakReference<R>> map = this.componentMap;
        synchronized (map) {
            WeakReference<R> weakReference;
            if (this.exists(uniqueKey) && (weakReference = this.componentMap.get(uniqueKey)) != null) {
                readyObject = (FacadeReady)weakReference.get();
            }
        }
        return (E)readyObject;
    }

    public <E extends R> E retrieve(Class<E> clazz, Object ... keyPart) {
        return this.retrieve(Key.create(clazz, keyPart));
    }

    protected <E extends R> E buildComponent(UniqueKey<E> uniqueKey) throws CoreException {
        FacadeReady readyObject = (FacadeReady)this.getGlobalFacade().getComponentFactory().buildComponent(uniqueKey.getClassField());
        JRebirthEventType type = JRebirthEventType.NONE;
        if (readyObject instanceof Model) {
            type = JRebirthEventType.CREATE_MODEL;
        } else if (readyObject instanceof Service) {
            type = JRebirthEventType.CREATE_SERVICE;
        } else if (readyObject instanceof Command) {
            type = JRebirthEventType.CREATE_COMMAND;
        }
        this.getGlobalFacade().trackEvent(type, this.getClass(), readyObject.getClass(), new String[0]);
        readyObject.setLocalFacade((LocalFacade)this);
        readyObject.setKey(uniqueKey);
        return (E)readyObject;
    }
}

